/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.http.response.source;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.officefloor.compile.spi.work.source.TaskTypeBuilder;
import net.officefloor.compile.spi.work.source.WorkTypeBuilder;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.api.build.TaskFactory;
import net.officefloor.frame.api.execute.TaskContext;
import net.officefloor.frame.api.execute.Work;
import net.officefloor.frame.util.AbstractSingleTask;
import net.officefloor.plugin.socket.server.http.HttpResponse;
import net.officefloor.plugin.socket.server.http.ServerHttpConnection;

public class HttpResponseSendTask
extends AbstractSingleTask<Work, HttpResponseSendTaskDependencies, None> {
    private final int status;
    private final ByteBuffer content;

    public static TaskTypeBuilder<HttpResponseSendTaskDependencies, None> addTaskType(String taskName, HttpResponseSendTask taskFactory, WorkTypeBuilder<Work> workTypeBuilder) {
        TaskTypeBuilder task = workTypeBuilder.addTaskType(taskName, (TaskFactory)taskFactory, HttpResponseSendTaskDependencies.class, None.class);
        task.addObject(ServerHttpConnection.class).setKey((Enum)HttpResponseSendTaskDependencies.SERVER_HTTP_CONNECTION);
        task.addEscalation(IOException.class);
        return task;
    }

    public HttpResponseSendTask(int status, byte[] content) {
        this.status = status;
        if (content == null) {
            this.content = null;
        } else {
            ByteBuffer buffer = ByteBuffer.allocateDirect(content.length);
            buffer.put(content);
            buffer.flip();
            this.content = buffer.asReadOnlyBuffer();
        }
    }

    public Object doTask(TaskContext<Work, HttpResponseSendTaskDependencies, None> context) throws IOException {
        ServerHttpConnection connection = (ServerHttpConnection)context.getObject((Enum)HttpResponseSendTaskDependencies.SERVER_HTTP_CONNECTION);
        HttpResponse response = connection.getHttpResponse();
        if (this.status > 0) {
            response.setStatus(this.status);
        }
        if (this.content != null) {
            response.getEntity().write(this.content);
        }
        response.send();
        return null;
    }

    public static enum HttpResponseSendTaskDependencies {
        SERVER_HTTP_CONNECTION;

    }
}

