/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.http.response.source;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import net.officefloor.compile.spi.work.source.WorkSourceContext;
import net.officefloor.compile.spi.work.source.WorkTypeBuilder;
import net.officefloor.compile.spi.work.source.impl.AbstractWorkSource;
import net.officefloor.frame.api.build.WorkFactory;
import net.officefloor.frame.api.execute.Work;
import net.officefloor.plugin.socket.server.http.response.source.HttpResponseSendTask;

public class HttpResponseSenderWorkSource
extends AbstractWorkSource<Work> {
    public static final String PROPERTY_HTTP_STATUS = "http.status";
    public static final String PROPERTY_HTTP_RESPONSE_CONTENT_FILE = "http.response.file";

    protected void loadSpecification(AbstractWorkSource.SpecificationContext context) {
    }

    public void sourceWork(WorkTypeBuilder<Work> workTypeBuilder, WorkSourceContext context) throws Exception {
        int httpStatus = Integer.parseInt(context.getProperty(PROPERTY_HTTP_STATUS, String.valueOf(-1)));
        String httpResponseFile = context.getProperty(PROPERTY_HTTP_RESPONSE_CONTENT_FILE, null);
        byte[] httpResponseContent = null;
        if (httpResponseFile != null) {
            InputStream httpResponseInputStream = context.getOptionalResource(httpResponseFile);
            if (httpResponseInputStream == null) {
                throw new FileNotFoundException("Can not find HTTP response file '" + httpResponseFile + "' on the class path");
            }
            ByteArrayOutputStream fileContent = new ByteArrayOutputStream();
            int data = httpResponseInputStream.read();
            while (data != -1) {
                fileContent.write(data);
                data = httpResponseInputStream.read();
            }
            httpResponseContent = fileContent.toByteArray();
        }
        HttpResponseSendTask task = new HttpResponseSendTask(httpStatus, httpResponseContent);
        workTypeBuilder.setWorkFactory((WorkFactory)task);
        HttpResponseSendTask.addTaskType("SEND", task, workTypeBuilder);
    }
}

