/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.http.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import junit.framework.Assert;
import net.officefloor.frame.api.build.ManagedObjectBuilder;
import net.officefloor.frame.api.build.ManagingOfficeBuilder;
import net.officefloor.frame.api.manage.OfficeFloor;
import net.officefloor.frame.impl.spi.team.PassiveTeam;
import net.officefloor.frame.spi.team.Team;
import net.officefloor.frame.test.AbstractOfficeConstructTestCase;
import net.officefloor.frame.test.MockTeamSource;
import net.officefloor.plugin.socket.server.http.server.HttpServicerBuilder;
import net.officefloor.plugin.socket.server.http.server.HttpServicerTask;
import net.officefloor.plugin.socket.server.http.source.HttpServerSocketManagedObjectSource;
import net.officefloor.plugin.socket.server.http.source.HttpsServerSocketManagedObjectSource;
import net.officefloor.plugin.socket.server.impl.AbstractServerSocketManagedObjectSource;
import net.officefloor.plugin.socket.server.ssl.SslEngineConfigurator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;

public abstract class MockHttpServer
extends AbstractOfficeConstructTestCase
implements HttpServicerBuilder {
    private static int portStart = 12643;
    private int port;
    private boolean isSetupSecure = false;
    private boolean isServerSecure = false;
    private final List<HttpClient> httpClients = new LinkedList<HttpClient>();

    public static synchronized int getAvailablePort() {
        int port = portStart++;
        return port;
    }

    public static String getEntityBody(HttpResponse response) throws IOException {
        return MockHttpServer.getEntityBody(response, Charset.defaultCharset());
    }

    public static String getEntityBody(HttpResponse response, Charset charset) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        InputStreamReader body = new InputStreamReader(entity.getContent(), charset);
        StringWriter buffer = new StringWriter();
        int character = ((Reader)body).read();
        while (character >= 0) {
            buffer.write(character);
            character = ((Reader)body).read();
        }
        return buffer.toString();
    }

    public void setupSecure() {
        this.isSetupSecure = true;
    }

    public void startup(HttpServicerBuilder servicerBuilder) throws Exception {
        ManagedObjectBuilder serverSocketBuilder;
        super.setUp();
        AbstractServerSocketManagedObjectSource.closeConnectionManager();
        this.port = MockHttpServer.getAvailablePort();
        String officeName = this.getOfficeName();
        String MO_NAME = "MO";
        if (this.isSetupSecure) {
            this.isServerSecure = true;
            serverSocketBuilder = this.constructManagedObject("MO", HttpsServerSocketManagedObjectSource.class);
            this.constructManagedObjectSourceTeam("MO", "SSL_TASKS", (Team)MockTeamSource.createOnePersonTeam((String)"SSL_TASKS"));
            serverSocketBuilder.addProperty("ssl.engine.configurator.class", TestSslEngineConfigurator.class.getName());
        } else {
            this.isServerSecure = false;
            serverSocketBuilder = this.constructManagedObject("MO", HttpServerSocketManagedObjectSource.class);
        }
        serverSocketBuilder.addProperty("port", String.valueOf(this.port));
        serverSocketBuilder.setTimeout(3000L);
        ManagingOfficeBuilder managingOfficeBuilder = serverSocketBuilder.setManagingOffice(officeName);
        managingOfficeBuilder.setInputManagedObjectName("MO");
        this.constructManagedObjectSourceTeam("MO", "accepter", (Team)MockTeamSource.createWorkerPerTaskTeam((String)"accepter"));
        this.constructManagedObjectSourceTeam("MO", "listener", (Team)MockTeamSource.createWorkerPerTaskTeam((String)"listener"));
        this.constructManagedObjectSourceTeam("MO", "cleanup", (Team)new PassiveTeam());
        HttpServicerTask task = servicerBuilder.buildServicer("MO", this);
        managingOfficeBuilder.linkProcess(0, task.workName, task.taskName);
        OfficeFloor officeFloor = this.constructOfficeFloor();
        officeFloor.openOfficeFloor();
    }

    private void constructManagedObjectSourceTeam(String managedObjectName, String managedObjectTeamName, Team team) {
        this.constructTeam(managedObjectTeamName, team);
        this.getOfficeBuilder().registerTeam("of-" + managedObjectName + "." + managedObjectTeamName, "of-" + managedObjectTeamName);
    }

    public boolean isServerSecure() {
        return this.isServerSecure;
    }

    public String getServerUrl() {
        return (this.isServerSecure() ? "https" : "http") + "://localhost:" + this.port;
    }

    public HttpClient createHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        if (this.isServerSecure()) {
            MockSocketFactory socketFactory = new MockSocketFactory();
            Scheme scheme = new Scheme("https", (SocketFactory)socketFactory, this.port);
            client.getConnectionManager().getSchemeRegistry().register(scheme);
        }
        this.httpClients.add((HttpClient)client);
        return client;
    }

    public InetSocketAddress getLocalAddress() {
        try {
            return new InetSocketAddress(InetAddress.getLocalHost().getHostAddress(), this.port);
        }
        catch (Exception ex) {
            throw MockHttpServer.fail((Throwable)ex);
        }
    }

    public void shutdown() throws Exception {
        this.tearDown();
    }

    protected void setUp() throws Exception {
        this.startup(this);
    }

    protected void tearDown() throws Exception {
        for (HttpClient client : this.httpClients) {
            client.getConnectionManager().shutdown();
        }
        super.tearDown();
    }

    @Override
    public HttpServicerTask buildServicer(String managedObjectName, MockHttpServer server) throws Exception {
        MockHttpServer.fail((String)("Must override " + HttpServicerBuilder.class.getSimpleName() + " test case implementation"));
        return null;
    }

    private class MockSocketFactory
    implements LayeredSocketFactory {
        private MockSocketFactory() {
        }

        public Socket createSocket() throws IOException {
            SSLContext context;
            try {
                context = SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IOException("Failed to obtain default " + SSLContext.class.getSimpleName(), ex);
            }
            SSLSocketFactory socketFactory = context.getSocketFactory();
            Socket socket = socketFactory.createSocket();
            Assert.assertFalse((String)"Socket should not be connected", (boolean)socket.isConnected());
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.setEnabledCipherSuites(sslSocket.getSupportedCipherSuites());
            return sslSocket;
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return socket;
        }

        public Socket connectSocket(Socket socket, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            socket.connect(new InetSocketAddress(host, port));
            Assert.assertTrue((String)"Socket should now be connected", (boolean)socket.isConnected());
            return socket;
        }

        public boolean isSecure(Socket socket) throws IllegalArgumentException {
            return socket instanceof SSLSocket;
        }
    }

    public static class TestSslEngineConfigurator
    implements SslEngineConfigurator {
        @Override
        public void init(SSLContext context) throws Exception {
        }

        @Override
        public void configureSslEngine(SSLEngine engine) {
            engine.setEnabledCipherSuites(engine.getSupportedCipherSuites());
        }
    }
}

