/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.officefloor.frame.api.build.Indexed;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.api.build.TaskFactory;
import net.officefloor.frame.api.build.WorkFactory;
import net.officefloor.frame.api.execute.TaskContext;
import net.officefloor.frame.api.execute.Work;
import net.officefloor.frame.spi.managedobject.ManagedObject;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectExecuteContext;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectSourceContext;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectTaskBuilder;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractAsyncManagedObjectSource;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractManagedObjectSource;
import net.officefloor.frame.util.AbstractSingleTask;
import net.officefloor.plugin.socket.server.ConnectionManager;
import net.officefloor.plugin.socket.server.impl.ConnectionManagerImpl;
import net.officefloor.plugin.socket.server.impl.ServerSocketAccepter;
import net.officefloor.plugin.socket.server.impl.SocketListener;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocol;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocolContext;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocolSource;

public abstract class AbstractServerSocketManagedObjectSource
extends AbstractManagedObjectSource<None, Indexed>
implements CommunicationProtocolContext {
    private final Logger LOGGER = Logger.getLogger(this.getClass().getName());
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_SEND_BUFFER_SIZE = "send.buffer.size";
    public static final String PROPERTY_RECEIVE_BUFFER_SIZE = "receive.buffer.size";
    public static final String PROPERTY_DEFAULT_CHARSET = "default.charset";
    private static ConnectionManager singletonConnectionManager;
    private static Set<AbstractServerSocketManagedObjectSource> registeredServerSockets;
    private final CommunicationProtocolSource communicationProtocolSource = this.createCommunicationProtocolSource();
    private ServerSocketAccepter serverSocketAccepter;
    private int sendBufferSize;
    private Charset defaultCharset;
    private CommunicationProtocol communicationProtocol;

    private static synchronized ConnectionManager getConnectionManager(ManagedObjectSourceContext<Indexed> mosContext, AbstractServerSocketManagedObjectSource instance, long heartBeatInterval, int sendBufferSize, int receiveBufferSize) {
        String listenerTeamName = "listener";
        AbstractSingleTask<Work, None, None> dummy = new AbstractSingleTask<Work, None, None>(){

            public Object doTask(TaskContext<Work, None, None> context) throws Throwable {
                throw new IllegalStateException("Dummy auto-wire listener task should not be invoked");
            }
        };
        mosContext.addWork("SetupAutoWireListener", (WorkFactory)dummy).addTask("SetupAutoWireListener", (TaskFactory)dummy).setTeam("listener");
        if (mosContext.isLoadingType()) {
            return null;
        }
        if (singletonConnectionManager == null) {
            int numberOfSocketListeners = Runtime.getRuntime().availableProcessors();
            SocketListener[] socketListeners = new SocketListener[numberOfSocketListeners];
            for (int i = 0; i < socketListeners.length; ++i) {
                SocketListener socketListener;
                socketListeners[i] = socketListener = new SocketListener(sendBufferSize, receiveBufferSize);
                String listenerName = "listener-" + i;
                ManagedObjectTaskBuilder listenerTask = mosContext.addWork(listenerName, (WorkFactory)socketListener).addTask(listenerName, (TaskFactory)socketListener);
                listenerTask.setTeam("listener");
                mosContext.addStartupTask(listenerName, listenerName);
            }
            ConnectionManagerImpl connectionManager = new ConnectionManagerImpl(heartBeatInterval, socketListeners);
            singletonConnectionManager = connectionManager;
            String heartBeatName = "heartbeat";
            ManagedObjectTaskBuilder heartBeatTask = mosContext.addWork(heartBeatName, (WorkFactory)connectionManager).addTask(heartBeatName, (TaskFactory)connectionManager);
            heartBeatTask.setTeam("listener");
            mosContext.addStartupTask(heartBeatName, heartBeatName);
        }
        registeredServerSockets.add(instance);
        return singletonConnectionManager;
    }

    private static synchronized void openSocketListenerSelectors() throws IOException {
        singletonConnectionManager.openSocketSelectors();
    }

    public static synchronized void closeConnectionManager() throws IOException {
        registeredServerSockets.clear();
        if (singletonConnectionManager != null) {
            singletonConnectionManager.closeSocketSelectors();
        }
        singletonConnectionManager = null;
    }

    private static synchronized void releaseConnectionManager(AbstractServerSocketManagedObjectSource instance) throws IOException {
        registeredServerSockets.remove(instance);
        if (registeredServerSockets.size() == 0) {
            AbstractServerSocketManagedObjectSource.closeConnectionManager();
        }
    }

    protected abstract CommunicationProtocolSource createCommunicationProtocolSource();

    @Override
    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    @Override
    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    protected void loadSpecification(AbstractAsyncManagedObjectSource.SpecificationContext context) {
        context.addProperty(PROPERTY_PORT);
        this.communicationProtocolSource.loadSpecification(context);
    }

    protected void loadMetaData(AbstractAsyncManagedObjectSource.MetaDataContext<None, Indexed> context) throws Exception {
        ManagedObjectSourceContext mosContext = context.getManagedObjectSourceContext();
        Socket socket = new Socket();
        int osSendBufferSize = socket.getSendBufferSize();
        int osReceiveBufferSize = socket.getReceiveBufferSize();
        socket.close();
        int port = Integer.parseInt(mosContext.getProperty(PROPERTY_PORT));
        this.sendBufferSize = Integer.parseInt(mosContext.getProperty(PROPERTY_SEND_BUFFER_SIZE, String.valueOf(osSendBufferSize)));
        int receiveBufferSize = Integer.parseInt(mosContext.getProperty(PROPERTY_RECEIVE_BUFFER_SIZE, String.valueOf(osReceiveBufferSize)));
        String defaultCharsetName = mosContext.getProperty(PROPERTY_DEFAULT_CHARSET, "ISO-8859-1");
        this.defaultCharset = Charset.forName(defaultCharsetName);
        int serverSocketBackLog = 25000;
        long heartBeatInterval = 10000L;
        ConnectionManager connectionManager = AbstractServerSocketManagedObjectSource.getConnectionManager((ManagedObjectSourceContext<Indexed>)mosContext, this, heartBeatInterval, this.sendBufferSize, receiveBufferSize);
        this.communicationProtocol = this.communicationProtocolSource.createCommunicationProtocol(context, this);
        this.serverSocketAccepter = new ServerSocketAccepter(new InetSocketAddress(port), this.communicationProtocol, connectionManager, serverSocketBackLog);
        ManagedObjectTaskBuilder accepterTask = mosContext.addWork("accepter", (WorkFactory)this.serverSocketAccepter).addTask("accepter", (TaskFactory)this.serverSocketAccepter);
        accepterTask.setTeam("accepter");
        mosContext.addStartupTask("accepter", "accepter");
    }

    public void start(ManagedObjectExecuteContext<Indexed> context) throws Exception {
        this.communicationProtocol.setManagedObjectExecuteContext(context);
        AbstractServerSocketManagedObjectSource.openSocketListenerSelectors();
        this.serverSocketAccepter.bindToSocket();
    }

    protected ManagedObject getManagedObject() throws Throwable {
        throw new IllegalStateException("Can not source managed object from a " + this.getClass().getSimpleName());
    }

    public void stop() {
        block5: {
            block4: {
                try {
                    this.serverSocketAccepter.unbindFromSocket();
                }
                catch (IOException ex) {
                    if (!this.LOGGER.isLoggable(Level.INFO)) break block4;
                    this.LOGGER.log(Level.INFO, "Failed to unbind from Socket", ex);
                }
            }
            try {
                AbstractServerSocketManagedObjectSource.releaseConnectionManager(this);
            }
            catch (IOException ex) {
                if (!this.LOGGER.isLoggable(Level.INFO)) break block5;
                this.LOGGER.log(Level.INFO, "Failed to release " + ConnectionManager.class.getSimpleName(), ex);
            }
        }
    }

    static {
        registeredServerSockets = new HashSet<AbstractServerSocketManagedObjectSource>();
    }
}

