/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.officefloor.plugin.socket.server.ManagedConnection;
import net.officefloor.plugin.socket.server.WriteDataAction;
import net.officefloor.plugin.socket.server.impl.ArrayWriteBuffer;
import net.officefloor.plugin.socket.server.impl.BufferWriteBuffer;
import net.officefloor.plugin.socket.server.impl.SocketListener;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocol;
import net.officefloor.plugin.socket.server.protocol.Connection;
import net.officefloor.plugin.socket.server.protocol.ConnectionHandler;
import net.officefloor.plugin.socket.server.protocol.WriteBuffer;
import net.officefloor.plugin.socket.server.protocol.WriteBufferEnum;

public class ConnectionImpl
implements Connection,
ManagedConnection,
WriteDataAction {
    private static final Logger LOGGER = Logger.getLogger(ConnectionImpl.class.getName());
    private final SelectionKey selectionKey;
    private final SocketChannel socketChannel;
    private final ConnectionHandler connectionHandler;
    private final SocketListener socketListener;
    private final Queue<WriteAction> writeActions = new LinkedList<WriteAction>();
    private boolean isRegisteredForWrite = false;
    private volatile boolean isTerminateAfterWrites = false;
    private volatile boolean isClosed = false;

    public ConnectionImpl(SelectionKey selectionKey, SocketChannel socketChannel, CommunicationProtocol communicationProtocol, SocketListener socketListener) {
        this.selectionKey = selectionKey;
        this.socketChannel = socketChannel;
        this.socketListener = socketListener;
        this.connectionHandler = communicationProtocol.createConnectionHandler(this);
    }

    @Override
    public Object getLock() {
        return this;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public WriteBuffer createWriteBuffer(byte[] data, int length) {
        return new ArrayWriteBuffer(data, length);
    }

    @Override
    public WriteBuffer createWriteBuffer(ByteBuffer buffer) {
        return new BufferWriteBuffer(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(WriteBuffer[] data) throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isTerminateAfterWrites) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Attempting to write data after closing connection");
                }
                return;
            }
            this.writeActions.add(new WriteAction(data));
            this.flushWrites();
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        Socket socket = this.socketChannel.socket();
        return new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        Socket socket = this.socketChannel.socket();
        return new InetSocketAddress(socket.getInetAddress(), socket.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            this.isClosed = true;
            this.isTerminateAfterWrites = true;
            this.flushWrites();
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private void flushWrites() throws IOException {
        if (!this.isRegisteredForWrite && !this.processWriteQueue()) {
            this.isRegisteredForWrite = true;
            this.socketListener.registerWriteDataAction(this);
        }
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processWriteQueue() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            this.isRegisteredForWrite = false;
            try {
                Iterator iterator = this.writeActions.iterator();
                while (iterator.hasNext()) {
                    WriteAction action = (WriteAction)iterator.next();
                    if (!action.writeData()) {
                        return false;
                    }
                    iterator.remove();
                }
            }
            catch (IOException ex) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Failed to write data", ex);
                }
                this.terminate();
            }
            if (this.isTerminateAfterWrites) {
                this.terminate();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            this.isClosed = true;
            this.isTerminateAfterWrites = true;
            this.socketChannel.close();
            this.selectionKey.cancel();
            for (WriteAction action : this.writeActions) {
                action.cleanup();
            }
            this.writeActions.clear();
        }
    }

    @Override
    public ManagedConnection getConnection() {
        return this;
    }

    private class WriteAction {
        private final ByteBuffer[] buffers;
        private final boolean[] isPooled;
        private int startIndex = 0;
        private int nextIndex = 0;

        public WriteAction(WriteBuffer[] writeBuffers) {
            this.buffers = new ByteBuffer[writeBuffers.length];
            this.isPooled = new boolean[this.buffers.length];
            ByteBuffer currentBuffer = ConnectionImpl.this.socketListener.getWriteBufferFromPool();
            block4: for (int i = 0; i < writeBuffers.length; ++i) {
                WriteBuffer writeBuffer = writeBuffers[i];
                WriteBufferEnum type = writeBuffer.getType();
                switch (type) {
                    case BYTE_ARRAY: {
                        int loadSize;
                        byte[] data = writeBuffer.getData();
                        int length = writeBuffer.length();
                        for (int offset = 0; offset < length; offset += loadSize) {
                            int remaining = currentBuffer.remaining();
                            loadSize = Math.min(length - offset, remaining);
                            currentBuffer.put(data, offset, loadSize);
                            if (currentBuffer.remaining() != 0) continue;
                            currentBuffer.flip();
                            this.addBuffer(currentBuffer, true);
                            currentBuffer = ConnectionImpl.this.socketListener.getWriteBufferFromPool();
                        }
                        continue block4;
                    }
                    case BYTE_BUFFER: {
                        if (currentBuffer.position() > 0) {
                            currentBuffer.flip();
                            this.addBuffer(currentBuffer, true);
                            currentBuffer = ConnectionImpl.this.socketListener.getWriteBufferFromPool();
                        }
                        this.addBuffer(writeBuffer.getDataBuffer(), false);
                        continue block4;
                    }
                    default: {
                        throw new IllegalStateException("Unknown " + WriteBuffer.class.getSimpleName() + " type: " + (Object)((Object)type));
                    }
                }
            }
            if (currentBuffer.position() > 0) {
                currentBuffer.flip();
                this.addBuffer(currentBuffer, true);
            } else {
                ConnectionImpl.this.socketListener.returnWriteBufferToPool(currentBuffer);
            }
        }

        public boolean writeData() throws IOException {
            SocketChannel socketChannel = ConnectionImpl.this.getSocketChannel();
            IOException failure = null;
            try {
                socketChannel.write(this.buffers, this.startIndex, this.nextIndex - this.startIndex);
            }
            catch (IOException ex) {
                failure = ex;
            }
            while (this.startIndex < this.nextIndex && (this.buffers[this.startIndex].remaining() == 0 || failure != null)) {
                if (this.isPooled[this.startIndex]) {
                    ConnectionImpl.this.socketListener.returnWriteBufferToPool(this.buffers[this.startIndex]);
                }
                ++this.startIndex;
            }
            if (failure != null) {
                throw failure;
            }
            return this.startIndex >= this.nextIndex;
        }

        private void cleanup() {
            for (int i = this.startIndex; i < this.nextIndex; ++i) {
                if (!this.isPooled[i]) continue;
                ConnectionImpl.this.socketListener.returnWriteBufferToPool(this.buffers[i]);
            }
        }

        private void addBuffer(ByteBuffer buffer, boolean isPooled) {
            this.buffers[this.nextIndex] = buffer;
            this.isPooled[this.nextIndex] = isPooled;
            ++this.nextIndex;
        }
    }
}

