/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.impl;

import java.io.IOException;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.api.execute.TaskContext;
import net.officefloor.frame.util.AbstractSingleTask;
import net.officefloor.plugin.socket.server.ConnectionManager;
import net.officefloor.plugin.socket.server.EstablishedConnection;
import net.officefloor.plugin.socket.server.impl.SocketListener;

public class ConnectionManagerImpl
extends AbstractSingleTask<ConnectionManagerImpl, None, None>
implements ConnectionManager {
    private final long heartbeatInterval;
    private final SocketListener[] socketListeners;
    private int nextSocketListener = 0;
    private volatile boolean isClosed = false;

    public ConnectionManagerImpl(long heartbeatInterval, SocketListener ... socketListeners) {
        this.heartbeatInterval = heartbeatInterval;
        this.socketListeners = socketListeners;
    }

    @Override
    public void openSocketSelectors() throws IOException {
        for (SocketListener socketListener : this.socketListeners) {
            socketListener.openSelector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manageConnection(EstablishedConnection connection) {
        SocketListener[] socketListenerArray = this.socketListeners;
        synchronized (this.socketListeners) {
            int next = this.nextSocketListener;
            this.nextSocketListener = (this.nextSocketListener + 1) % this.socketListeners.length;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            this.socketListeners[next].registerEstablishedConnection(connection);
            return;
        }
    }

    @Override
    public void closeSocketSelectors() throws IOException {
        this.isClosed = true;
        for (SocketListener socketListener : this.socketListeners) {
            socketListener.closeSelector();
        }
    }

    public Object doTask(TaskContext<ConnectionManagerImpl, None, None> context) throws Throwable {
        context.setComplete(this.isClosed);
        Thread.sleep(this.heartbeatInterval);
        for (SocketListener socketListener : this.socketListeners) {
            socketListener.doHeartBeat();
        }
        return null;
    }
}

