/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.api.execute.TaskContext;
import net.officefloor.frame.util.AbstractSingleTask;
import net.officefloor.plugin.socket.server.ConnectionManager;
import net.officefloor.plugin.socket.server.EstablishedConnection;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocol;

public class ServerSocketAccepter
extends AbstractSingleTask<ServerSocketAccepter, None, None> {
    private final CommunicationProtocol communicationProtocol;
    private final ConnectionManager connectionManager;
    private final InetSocketAddress serverSocketAddress;
    private final int serverSocketBackLogSize;
    private ServerSocketChannel channel;
    private Selector selector;
    private volatile boolean isComplete = false;

    public ServerSocketAccepter(InetSocketAddress serverSocketAddress, CommunicationProtocol communicationProtocol, ConnectionManager connectionManager, int serverSocketBackLogSize) throws IOException {
        this.communicationProtocol = communicationProtocol;
        this.connectionManager = connectionManager;
        this.serverSocketAddress = serverSocketAddress;
        this.serverSocketBackLogSize = serverSocketBackLogSize;
    }

    void bindToSocket() throws IOException {
        this.channel = ServerSocketChannel.open();
        this.channel.configureBlocking(false);
        ServerSocket socket = this.channel.socket();
        socket.setReuseAddress(true);
        socket.bind(this.serverSocketAddress, this.serverSocketBackLogSize);
        this.selector = Selector.open();
        this.channel.register(this.selector, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindFromSocket() throws IOException {
        this.isComplete = true;
        if (this.selector != null) {
            this.selector.wakeup();
        }
        ServerSocketAccepter serverSocketAccepter = this;
        synchronized (serverSocketAccepter) {
            try {
                this.selector.close();
            }
            finally {
                this.channel.socket().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTask(TaskContext<ServerSocketAccepter, None, None> context) throws Exception {
        ServerSocketAccepter serverSocketAccepter = this;
        synchronized (serverSocketAccepter) {
            boolean isComplete = this.isComplete;
            context.setComplete(isComplete);
            if (isComplete) {
                return null;
            }
            this.selector.select(10000L);
            Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SocketChannel socketChannel;
                SelectionKey key = iterator.next();
                iterator.remove();
                if (!key.isAcceptable() || (socketChannel = this.channel.accept()) == null) continue;
                socketChannel.configureBlocking(false);
                Socket socket = socketChannel.socket();
                socket.setTcpNoDelay(true);
                EstablishedConnectionImpl connection = new EstablishedConnectionImpl(socketChannel);
                this.connectionManager.manageConnection(connection);
            }
        }
        return null;
    }

    private class EstablishedConnectionImpl
    implements EstablishedConnection {
        private final SocketChannel socketChannel;

        public EstablishedConnectionImpl(SocketChannel socketChannel) {
            this.socketChannel = socketChannel;
        }

        @Override
        public SocketChannel getSocketChannel() {
            return this.socketChannel;
        }

        @Override
        public CommunicationProtocol getCommunicationProtocol() {
            return ServerSocketAccepter.this.communicationProtocol;
        }
    }
}

