/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.officefloor.frame.api.build.Indexed;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.api.execute.FlowFuture;
import net.officefloor.frame.api.execute.TaskContext;
import net.officefloor.frame.api.manage.InvalidParameterTypeException;
import net.officefloor.frame.api.manage.UnknownTaskException;
import net.officefloor.frame.api.manage.UnknownWorkException;
import net.officefloor.frame.util.AbstractSingleTask;
import net.officefloor.plugin.socket.server.EstablishedConnection;
import net.officefloor.plugin.socket.server.ManagedConnection;
import net.officefloor.plugin.socket.server.WriteDataAction;
import net.officefloor.plugin.socket.server.impl.ConnectionImpl;
import net.officefloor.plugin.socket.server.protocol.HeartBeatContext;
import net.officefloor.plugin.socket.server.protocol.ReadContext;

public class SocketListener
extends AbstractSingleTask<SocketListener, None, Indexed>
implements ReadContext,
HeartBeatContext {
    private static final Logger LOGGER = Logger.getLogger(SocketListener.class.getName());
    private final Queue<EstablishedConnection> establishedConnections = new ConcurrentLinkedQueue<EstablishedConnection>();
    private final ByteBuffer readBuffer;
    private final int sendBufferSize;
    private final Queue<WriteDataAction> writeActions = new ConcurrentLinkedQueue<WriteDataAction>();
    private final Queue<ByteBuffer> writeBufferPool = new ConcurrentLinkedQueue<ByteBuffer>();
    private Selector selector;
    private volatile boolean isStopListening = false;
    private long currentTime = -1L;
    private byte[] readData;

    public SocketListener(int sendBufferSize, int receiveBufferSize) {
        this.sendBufferSize = sendBufferSize;
        this.readBuffer = ByteBuffer.allocateDirect(receiveBufferSize);
    }

    void openSelector() throws IOException {
        this.selector = Selector.open();
    }

    void closeSelector() {
        block3: {
            this.isStopListening = true;
            this.selector.wakeup();
            try {
                CloseSelectorTaskContext context = new CloseSelectorTaskContext();
                while (!context.isComplete()) {
                    this.doTask(context);
                }
            }
            catch (Exception ex) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                LOGGER.log(Level.WARNING, "Failed to close Selector", ex);
            }
        }
    }

    void registerEstablishedConnection(EstablishedConnection connection) {
        this.establishedConnections.add(connection);
        this.selector.wakeup();
    }

    void registerWriteDataAction(WriteDataAction writeDataAction) {
        this.writeActions.add(writeDataAction);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doHeartBeat() {
        SocketListener socketListener = this;
        synchronized (socketListener) {
            this.currentTime = -1L;
            if (this.selector.isOpen()) {
                for (SelectionKey selectionKey : this.selector.keys()) {
                    ManagedConnection connection = this.getManagedConnection(selectionKey);
                    try {
                        connection.getConnectionHandler().handleHeartbeat(this);
                    }
                    catch (IOException ex) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.log(Level.FINE, "Failed heart beat for connection", ex);
                    }
                }
            }
        }
    }

    ByteBuffer getWriteBufferFromPool() {
        ByteBuffer buffer = this.writeBufferPool.poll();
        if (buffer != null) {
            buffer.clear();
        } else {
            buffer = ByteBuffer.allocateDirect(this.sendBufferSize);
        }
        return buffer;
    }

    void returnWriteBufferToPool(ByteBuffer buffer) {
        this.writeBufferPool.add(buffer);
    }

    private ManagedConnection getManagedConnection(SelectionKey selectionKey) {
        return (ManagedConnection)selectionKey.attachment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTask(TaskContext<SocketListener, None, Indexed> context) throws Exception {
        SocketListener socketListener = this;
        synchronized (socketListener) {
            WriteDataAction action;
            ManagedConnection connection;
            EstablishedConnection establishedConnection;
            context.setComplete(false);
            int establishedConnectionCount = this.establishedConnections.size();
            while (establishedConnectionCount-- > 0 && (establishedConnection = this.establishedConnections.poll()) != null) {
                SocketChannel socketChannel = establishedConnection.getSocketChannel();
                SelectionKey selectionKey = socketChannel.register(this.selector, 1);
                connection = new ConnectionImpl(selectionKey, socketChannel, establishedConnection.getCommunicationProtocol(), this);
                selectionKey.attach(connection);
            }
            int actionCount = this.writeActions.size();
            while (actionCount-- > 0 && (action = this.writeActions.poll()) != null) {
                connection = action.getConnection();
                if (connection.processWriteQueue()) continue;
                connection.getSelectionKey().interestOps(5);
            }
            if (this.isStopListening) {
                if (!this.selector.isOpen()) {
                    context.setComplete(true);
                    return null;
                }
                Set<SelectionKey> allKeys = this.selector.keys();
                if (allKeys.size() == 0) {
                    block19: {
                        try {
                            this.selector.close();
                        }
                        catch (IOException ex) {
                            if (!LOGGER.isLoggable(Level.WARNING)) break block19;
                            LOGGER.log(Level.WARNING, "Failed to close selector", ex);
                        }
                    }
                    context.setComplete(true);
                    return null;
                }
                for (SelectionKey key : allKeys) {
                    this.getManagedConnection(key).terminate();
                }
            }
            this.selector.select(1000L);
            this.currentTime = -1L;
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            block12: for (SelectionKey selectedKey : selectedKeys) {
                ManagedConnection connection2 = this.getManagedConnection(selectedKey);
                SocketChannel socketChannel = connection2.getSocketChannel();
                try {
                    if (selectedKey.isReadable()) {
                        boolean isFurtherDataToRead = true;
                        while (isFurtherDataToRead) {
                            int bytesRead;
                            ByteBuffer buffer = this.readBuffer.duplicate();
                            try {
                                bytesRead = socketChannel.read(buffer);
                            }
                            catch (IOException ex) {
                                connection2.terminate();
                                continue block12;
                            }
                            if (bytesRead < 0) {
                                connection2.terminate();
                                continue block12;
                            }
                            buffer.flip();
                            this.readData = new byte[bytesRead];
                            buffer.get(this.readData);
                            connection2.getConnectionHandler().handleRead(this);
                            if (bytesRead >= this.readBuffer.limit()) continue;
                            isFurtherDataToRead = false;
                        }
                    }
                    if (!selectedKey.isWritable() || !connection2.processWriteQueue()) continue;
                    selectedKey.interestOps(1);
                }
                catch (CancelledKeyException ex) {
                    connection2.terminate();
                }
            }
            selectedKeys.clear();
        }
        return null;
    }

    @Override
    public long getTime() {
        if (this.currentTime == -1L) {
            this.currentTime = System.currentTimeMillis();
        }
        return this.currentTime;
    }

    @Override
    public byte[] getData() {
        return this.readData;
    }

    private class CloseSelectorTaskContext
    implements TaskContext<SocketListener, None, Indexed> {
        private boolean isComplete = false;

        private CloseSelectorTaskContext() {
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        public SocketListener getWork() {
            return SocketListener.this;
        }

        public Object getProcessLock() {
            return this;
        }

        public Object getObject(None key) {
            throw new IllegalStateException("No dependency should be required for close Selector");
        }

        public Object getObject(int dependencyIndex) {
            throw new IllegalStateException("No dependency should be required for close Selector");
        }

        public FlowFuture doFlow(Indexed key, Object parameter) {
            throw new IllegalStateException("No flow should be required for close Selector");
        }

        public FlowFuture doFlow(int flowIndex, Object parameter) {
            throw new IllegalStateException("No flow should be required for close Selector");
        }

        public void doFlow(String workName, String taskName, Object parameter) throws UnknownWorkException, UnknownTaskException, InvalidParameterTypeException {
            throw new IllegalStateException("No flow should be required for close Selector");
        }

        public void join(FlowFuture flowFuture, long timeout, Object token) throws IllegalArgumentException {
            throw new IllegalStateException("Join should be required for close Selector");
        }

        public void setComplete(boolean isComplete) {
            this.isComplete = isComplete;
        }
    }
}

