/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.ssl.protocol;

import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import net.officefloor.frame.api.build.Indexed;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.api.build.TaskFactory;
import net.officefloor.frame.api.build.WorkFactory;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectExecuteContext;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectSourceContext;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectTaskBuilder;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectWorkBuilder;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractAsyncManagedObjectSource;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocol;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocolContext;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocolSource;
import net.officefloor.plugin.socket.server.protocol.Connection;
import net.officefloor.plugin.socket.server.ssl.SslEngineConfigurator;
import net.officefloor.plugin.socket.server.ssl.SslTaskExecutor;
import net.officefloor.plugin.socket.server.ssl.protocol.SslConnectionHandler;
import net.officefloor.plugin.socket.server.ssl.protocol.SslTaskWork;

public class SslCommunicationProtocol
implements CommunicationProtocolSource,
CommunicationProtocol,
SslTaskExecutor,
SslEngineConfigurator {
    public static final String PROPERTY_SSL_PROTOCOL = "ssl.protocol";
    public static final String PROPERTY_SSL_PROVIDER = "ssl.provider";
    public static final String PROPERTY_SSL_ENGINE_CONFIGURATOR = "ssl.engine.configurator.class";
    private final CommunicationProtocolSource wrappedCommunicationProtocolSource;
    private CommunicationProtocol wrappedCommunicationProtocol;
    private SSLContext sslContext;
    private SslEngineConfigurator sslEngineConfigurator;
    private int sendBufferSize;
    private ManagedObjectExecuteContext<Indexed> executeContext;
    private int sslTaskFlowIndex;

    public SslCommunicationProtocol(CommunicationProtocolSource wrappedCommunicationProtocolSource) {
        this.wrappedCommunicationProtocolSource = wrappedCommunicationProtocolSource;
    }

    @Override
    public void loadSpecification(AbstractAsyncManagedObjectSource.SpecificationContext context) {
        this.wrappedCommunicationProtocolSource.loadSpecification(context);
    }

    @Override
    public CommunicationProtocol createCommunicationProtocol(AbstractAsyncManagedObjectSource.MetaDataContext<None, Indexed> configurationContext, CommunicationProtocolContext protocolContext) throws Exception {
        String sslProvider;
        ManagedObjectSourceContext mosContext = configurationContext.getManagedObjectSourceContext();
        this.sendBufferSize = protocolContext.getSendBufferSize();
        this.wrappedCommunicationProtocol = this.wrappedCommunicationProtocolSource.createCommunicationProtocol(configurationContext, protocolContext);
        String sslProtocol = mosContext.getProperty(PROPERTY_SSL_PROTOCOL, null);
        this.sslContext = sslProtocol == null ? SSLContext.getDefault() : ((sslProvider = mosContext.getProperty(PROPERTY_SSL_PROVIDER, null)) == null ? SSLContext.getInstance(sslProtocol) : SSLContext.getInstance(sslProtocol, sslProvider));
        String sslEngineConfiguratorClassName = mosContext.getProperty(PROPERTY_SSL_ENGINE_CONFIGURATOR, null);
        this.sslEngineConfigurator = sslEngineConfiguratorClassName == null ? this : (SslEngineConfigurator)mosContext.loadClass(sslEngineConfiguratorClassName).newInstance();
        this.sslEngineConfigurator.init(this.sslContext);
        this.sslTaskFlowIndex = configurationContext.addFlow(Runnable.class).setLabel("SSL_TASKS").getIndex();
        SslTaskWork sslTaskExecution = new SslTaskWork();
        ManagedObjectWorkBuilder work = mosContext.addWork("SSL_TASK_EXECUTOR", (WorkFactory)sslTaskExecution);
        ManagedObjectTaskBuilder task = work.addTask("SSL_TASK_EXECUTOR", (TaskFactory)sslTaskExecution);
        task.linkParameter((Enum)SslTaskWork.SslTaskDependencies.TASK, Runnable.class);
        task.setTeam("SSL_TASKS");
        mosContext.linkProcess(this.sslTaskFlowIndex, "SSL_TASK_EXECUTOR", "SSL_TASK_EXECUTOR");
        return this;
    }

    @Override
    public void setManagedObjectExecuteContext(ManagedObjectExecuteContext<Indexed> executeContext) {
        this.executeContext = executeContext;
        this.wrappedCommunicationProtocol.setManagedObjectExecuteContext(executeContext);
    }

    @Override
    public SslConnectionHandler createConnectionHandler(Connection connection) {
        InetSocketAddress remoteAddress = connection.getRemoteAddress();
        String remoteHost = remoteAddress.getHostName();
        int remotePort = remoteAddress.getPort();
        SSLEngine engine = this.sslContext.createSSLEngine(remoteHost, remotePort);
        this.sslEngineConfigurator.configureSslEngine(engine);
        engine.setUseClientMode(false);
        SslConnectionHandler connectionHandler = new SslConnectionHandler(connection, engine, this, this.sendBufferSize, this.wrappedCommunicationProtocol);
        return connectionHandler;
    }

    @Override
    public void beginTask(Runnable task) {
        this.executeContext.invokeProcess(this.sslTaskFlowIndex, (Object)task, null, 0L);
    }

    @Override
    public void init(SSLContext context) throws Exception {
    }

    @Override
    public void configureSslEngine(SSLEngine engine) {
    }
}

