/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.ssl.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocol;
import net.officefloor.plugin.socket.server.protocol.Connection;
import net.officefloor.plugin.socket.server.protocol.ConnectionHandler;
import net.officefloor.plugin.socket.server.protocol.HeartBeatContext;
import net.officefloor.plugin.socket.server.protocol.ReadContext;
import net.officefloor.plugin.socket.server.protocol.WriteBuffer;
import net.officefloor.plugin.socket.server.protocol.WriteBufferEnum;
import net.officefloor.plugin.socket.server.ssl.SslTaskExecutor;
import net.officefloor.plugin.socket.server.ssl.protocol.SslConnectionImpl;

public class SslConnectionHandler
implements ConnectionHandler,
ReadContext,
HeartBeatContext {
    private final Connection connection;
    private final SSLEngine engine;
    private final SslTaskExecutor taskExecutor;
    private final int sendBufferSize;
    private final ConnectionHandler wrappedConnectionHandler;
    private final Queue<byte[]> readData = new LinkedList<byte[]>();
    private final Queue<WriteBuffer> writeData = new LinkedList<WriteBuffer>();
    private boolean isClosing = false;
    private SslTask task = null;
    private IOException failure = null;
    private byte[] readContextData = null;

    public SslConnectionHandler(Connection connection, SSLEngine engine, SslTaskExecutor taskExecutor, int sendBufferSize, CommunicationProtocol wrappedCommunicationProtocol) {
        this.engine = engine;
        this.taskExecutor = taskExecutor;
        this.sendBufferSize = sendBufferSize;
        this.connection = connection;
        SslConnectionImpl sslConnection = new SslConnectionImpl(this, this.connection);
        this.wrappedConnectionHandler = wrappedCommunicationProtocol.createConnectionHandler(sslConnection);
    }

    private void process() {
        try {
            if (this.failure != null || this.connection.isClosed()) {
                this.readData.clear();
                this.writeData.clear();
                return;
            }
            if (this.task != null) {
                return;
            }
            block32: while (true) {
                SSLEngineResult.HandshakeStatus closeHandshakeStatus;
                int bytesProduced;
                SSLEngineResult.Status status;
                byte[] furtherData;
                int bytesConsumed;
                SSLEngineResult sslEngineResult;
                boolean isInputData = false;
                boolean isOutputData = false;
                SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        if (this.readData.size() == 0) {
                            return;
                        }
                        isInputData = true;
                        break;
                    }
                    case NEED_WRAP: {
                        isOutputData = true;
                        break;
                    }
                    case NEED_TASK: {
                        Runnable delegatedTask = this.engine.getDelegatedTask();
                        this.task = new SslTask(delegatedTask);
                        this.taskExecutor.beginTask(this.task);
                        return;
                    }
                    case NOT_HANDSHAKING: {
                        isInputData = this.readData.size() > 0;
                        boolean bl = isOutputData = this.writeData.size() > 0 || this.isClosing;
                        if (isInputData || isOutputData) break;
                        return;
                    }
                    default: {
                        throw new IllegalStateException("Illegal " + SSLEngine.class.getSimpleName() + " handshake state " + (Object)((Object)handshakeStatus));
                    }
                }
                SSLSession session = this.engine.getSession();
                if (isInputData) {
                    int availableData = 0;
                    for (byte[] data : this.readData) {
                        availableData += data.length;
                    }
                    byte[] dataToUnwrap = new byte[availableData];
                    int readDataIndex = 0;
                    for (byte[] data : this.readData) {
                        System.arraycopy(data, 0, dataToUnwrap, readDataIndex, data.length);
                        readDataIndex += data.length;
                    }
                    this.readData.clear();
                    int packetBufferSize = session.getPacketBufferSize();
                    ByteBuffer dataToUnwrapBuffer = ByteBuffer.wrap(dataToUnwrap, 0, Math.min(dataToUnwrap.length, packetBufferSize));
                    int applicationBufferSize = session.getApplicationBufferSize();
                    byte[] tempBytes = new byte[applicationBufferSize];
                    ByteBuffer tempBuffer = ByteBuffer.wrap(tempBytes);
                    sslEngineResult = this.engine.unwrap(dataToUnwrapBuffer, tempBuffer);
                    bytesConsumed = sslEngineResult.bytesConsumed();
                    if (bytesConsumed < availableData) {
                        furtherData = new byte[availableData - bytesConsumed];
                        System.arraycopy(dataToUnwrap, bytesConsumed, furtherData, 0, furtherData.length);
                        this.readData.add(furtherData);
                    }
                    status = sslEngineResult.getStatus();
                    block7 : switch (status) {
                        case BUFFER_UNDERFLOW: {
                            return;
                        }
                        case OK: {
                            bytesProduced = sslEngineResult.bytesProduced();
                            if (bytesProduced <= 0) break;
                            this.readContextData = new byte[bytesProduced];
                            System.arraycopy(tempBytes, 0, this.readContextData, 0, bytesProduced);
                            this.wrappedConnectionHandler.handleRead(this);
                            break;
                        }
                        case CLOSED: {
                            closeHandshakeStatus = this.engine.getHandshakeStatus();
                            switch (closeHandshakeStatus) {
                                case NEED_UNWRAP: 
                                case NEED_WRAP: 
                                case NEED_TASK: {
                                    break block7;
                                }
                                case NOT_HANDSHAKING: {
                                    this.connection.close();
                                    return;
                                }
                            }
                            throw new IllegalStateException("Unknown status " + (Object)((Object)status));
                        }
                        default: {
                            throw new IllegalStateException("Unknown status " + (Object)((Object)status));
                        }
                    }
                }
                if (!isOutputData) continue;
                int packetBufferSize = session.getPacketBufferSize();
                byte[] tempBytes = new byte[packetBufferSize];
                ByteBuffer tempBuffer = ByteBuffer.wrap(tempBytes);
                int availableData = 0;
                block35: for (WriteBuffer buffer : this.writeData) {
                    WriteBufferEnum type = buffer.getType();
                    switch (type) {
                        case BYTE_ARRAY: {
                            availableData += buffer.length();
                            continue block35;
                        }
                        case BYTE_BUFFER: {
                            availableData += buffer.getDataBuffer().remaining();
                            continue block35;
                        }
                    }
                    throw new IllegalStateException("Unknown type " + (Object)((Object)type));
                }
                byte[] dataToWrap = new byte[availableData];
                int writeDataIndex = 0;
                block36: for (WriteBuffer buffer : this.writeData) {
                    WriteBufferEnum type = buffer.getType();
                    switch (type) {
                        case BYTE_ARRAY: {
                            byte[] data = buffer.getData();
                            int length = buffer.length();
                            System.arraycopy(data, 0, dataToWrap, writeDataIndex, length);
                            writeDataIndex += length;
                            continue block36;
                        }
                        case BYTE_BUFFER: {
                            ByteBuffer dataBuffer = buffer.getDataBuffer();
                            int length = dataBuffer.remaining();
                            dataBuffer.get(dataToWrap, writeDataIndex, length);
                            writeDataIndex += length;
                            continue block36;
                        }
                    }
                    throw new IllegalStateException("Unknown type " + (Object)((Object)type));
                }
                this.writeData.clear();
                int applicationBufferSize = session.getApplicationBufferSize();
                ByteBuffer dataToWrapBuffer = ByteBuffer.wrap(dataToWrap, 0, Math.min(dataToWrap.length, applicationBufferSize));
                sslEngineResult = this.engine.wrap(dataToWrapBuffer, tempBuffer);
                bytesConsumed = sslEngineResult.bytesConsumed();
                if (bytesConsumed < availableData) {
                    furtherData = new byte[availableData - bytesConsumed];
                    System.arraycopy(dataToWrap, bytesConsumed, furtherData, 0, furtherData.length);
                    this.writeData.add(this.connection.createWriteBuffer(furtherData, furtherData.length));
                } else if (this.isClosing) {
                    this.engine.closeOutbound();
                }
                status = sslEngineResult.getStatus();
                block24 : switch (status) {
                    case OK: 
                    case CLOSED: {
                        bytesProduced = sslEngineResult.bytesProduced();
                        if (bytesProduced > 0) {
                            int bytesToLoad;
                            int totalBytesLoaded;
                            byte[] cipherData = new byte[bytesProduced];
                            System.arraycopy(tempBytes, 0, cipherData, 0, bytesProduced);
                            WriteBuffer[] writeBuffers = new WriteBuffer[cipherData.length / this.sendBufferSize + (cipherData.length % this.sendBufferSize > 0 ? 1 : 0)];
                            writeBuffers[0] = this.connection.createWriteBuffer(cipherData, totalBytesLoaded);
                            int writeBufferIndex = 1;
                            for (totalBytesLoaded = Math.min(cipherData.length, this.sendBufferSize); totalBytesLoaded < cipherData.length; totalBytesLoaded += bytesToLoad) {
                                bytesToLoad = Math.min(cipherData.length - totalBytesLoaded, this.sendBufferSize);
                                byte[] writeBufferData = Arrays.copyOfRange(cipherData, totalBytesLoaded, totalBytesLoaded + bytesToLoad);
                                writeBuffers[writeBufferIndex++] = this.connection.createWriteBuffer(writeBufferData, bytesToLoad);
                            }
                            this.connection.writeData(writeBuffers);
                        }
                        if (status != SSLEngineResult.Status.CLOSED) continue block32;
                        closeHandshakeStatus = this.engine.getHandshakeStatus();
                        switch (closeHandshakeStatus) {
                            case NEED_UNWRAP: 
                            case NEED_WRAP: 
                            case NEED_TASK: {
                                break block24;
                            }
                            case NOT_HANDSHAKING: {
                                this.connection.close();
                                return;
                            }
                        }
                        throw new IllegalStateException("Unknown status " + (Object)((Object)status));
                    }
                    default: {
                        throw new IllegalStateException("Unknown status " + (Object)((Object)status));
                    }
                }
            }
        }
        catch (IOException ex) {
            this.failure = ex;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeData(WriteBuffer[] data) {
        Object object = this.connection.getLock();
        synchronized (object) {
            for (WriteBuffer buffer : data) {
                this.writeData.add(buffer);
            }
            this.process();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void triggerClose() {
        Object object = this.connection.getLock();
        synchronized (object) {
            this.isClosing = true;
            this.process();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosing() {
        Object object = this.connection.getLock();
        synchronized (object) {
            return this.isClosing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRead(ReadContext context) throws IOException {
        Object object = this.connection.getLock();
        synchronized (object) {
            this.readData.add(context.getData());
            this.process();
        }
    }

    @Override
    public void handleHeartbeat(HeartBeatContext context) throws IOException {
        this.wrappedConnectionHandler.handleHeartbeat(context);
    }

    @Override
    public long getTime() {
        return System.currentTimeMillis();
    }

    @Override
    public byte[] getData() {
        return this.readContextData;
    }

    private class SslTask
    implements Runnable {
        private final Runnable task;

        public SslTask(Runnable task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.task.run();
            }
            catch (Throwable ex) {
                Object object = SslConnectionHandler.this.connection.getLock();
                synchronized (object) {
                    SslConnectionHandler.this.failure = new IOException("SSL delegated task failed", ex);
                }
            }
            finally {
                Object object = SslConnectionHandler.this.connection.getLock();
                synchronized (object) {
                    SslConnectionHandler.this.task = null;
                    SslConnectionHandler.this.process();
                }
            }
        }
    }
}

