/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.ssl.protocol;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import net.officefloor.plugin.socket.server.protocol.Connection;
import net.officefloor.plugin.socket.server.protocol.WriteBuffer;
import net.officefloor.plugin.socket.server.ssl.protocol.SslConnectionHandler;

public class SslConnectionImpl
implements Connection {
    private final SslConnectionHandler connectionHandler;
    private final Connection wrappedConnection;

    public SslConnectionImpl(SslConnectionHandler connectionHandler, Connection wrappedConnection) {
        this.connectionHandler = connectionHandler;
        this.wrappedConnection = wrappedConnection;
    }

    @Override
    public Object getLock() {
        return this.wrappedConnection.getLock();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.wrappedConnection.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.wrappedConnection.getRemoteAddress();
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public WriteBuffer createWriteBuffer(byte[] data, int length) {
        return this.wrappedConnection.createWriteBuffer(data, length);
    }

    @Override
    public WriteBuffer createWriteBuffer(ByteBuffer buffer) {
        return this.wrappedConnection.createWriteBuffer(buffer);
    }

    @Override
    public void writeData(WriteBuffer[] data) {
        this.connectionHandler.writeData(data);
    }

    @Override
    public void close() {
        this.connectionHandler.triggerClose();
    }

    @Override
    public boolean isClosed() {
        return this.connectionHandler.isClosing() || this.wrappedConnection.isClosed();
    }
}

