/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.tcp.protocol;

import net.officefloor.frame.api.build.Indexed;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.spi.managedobject.ManagedObject;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectExecuteContext;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectSourceContext;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractAsyncManagedObjectSource;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocol;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocolContext;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocolSource;
import net.officefloor.plugin.socket.server.protocol.Connection;
import net.officefloor.plugin.socket.server.tcp.ServerTcpConnection;
import net.officefloor.plugin.socket.server.tcp.protocol.CleanupTask;
import net.officefloor.plugin.socket.server.tcp.protocol.TcpConnectionHandler;

public class TcpCommunicationProtocol
implements CommunicationProtocolSource,
CommunicationProtocol {
    public static final String PROPERTY_MAXIMUM_IDLE_TIME = "max.idle.time";
    public static final int DEFAULT_MAXIMUM_IDLE_TIME = 60;
    private long maxIdleTime;
    private int sendBufferSize;
    private int newConnectionFlowIndex;
    private ManagedObjectExecuteContext<Indexed> executeContext;

    public void serviceConnection(TcpConnectionHandler connectionHandler) {
        this.executeContext.invokeProcess(this.newConnectionFlowIndex, (Object)connectionHandler, (ManagedObject)connectionHandler, 0L);
    }

    @Override
    public void loadSpecification(AbstractAsyncManagedObjectSource.SpecificationContext context) {
        context.addProperty(PROPERTY_MAXIMUM_IDLE_TIME);
    }

    @Override
    public CommunicationProtocol createCommunicationProtocol(AbstractAsyncManagedObjectSource.MetaDataContext<None, Indexed> configurationContext, CommunicationProtocolContext protocolContext) throws Exception {
        ManagedObjectSourceContext mosContext = configurationContext.getManagedObjectSourceContext();
        this.maxIdleTime = Long.parseLong(mosContext.getProperty(PROPERTY_MAXIMUM_IDLE_TIME, String.valueOf(60)));
        this.sendBufferSize = protocolContext.getSendBufferSize();
        configurationContext.setManagedObjectClass(TcpConnectionHandler.class);
        configurationContext.setObjectClass(ServerTcpConnection.class);
        this.newConnectionFlowIndex = configurationContext.addFlow(ServerTcpConnection.class).setLabel("NEW_CONNECTION").getIndex();
        new CleanupTask().registerAsRecycleTask(mosContext, "cleanup");
        return this;
    }

    @Override
    public void setManagedObjectExecuteContext(ManagedObjectExecuteContext<Indexed> executeContext) {
        this.executeContext = executeContext;
    }

    @Override
    public TcpConnectionHandler createConnectionHandler(Connection connection) {
        return new TcpConnectionHandler(this, connection, this.sendBufferSize, this.maxIdleTime);
    }
}

