/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.tcp.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.officefloor.frame.spi.managedobject.AsynchronousListener;
import net.officefloor.frame.spi.managedobject.AsynchronousManagedObject;
import net.officefloor.plugin.socket.server.protocol.Connection;
import net.officefloor.plugin.socket.server.protocol.ConnectionHandler;
import net.officefloor.plugin.socket.server.protocol.HeartBeatContext;
import net.officefloor.plugin.socket.server.protocol.ReadContext;
import net.officefloor.plugin.socket.server.protocol.WriteBuffer;
import net.officefloor.plugin.socket.server.tcp.ServerTcpConnection;
import net.officefloor.plugin.socket.server.tcp.protocol.TcpCommunicationProtocol;
import net.officefloor.plugin.stream.ServerInputStream;
import net.officefloor.plugin.stream.ServerOutputStream;
import net.officefloor.plugin.stream.WriteBufferReceiver;
import net.officefloor.plugin.stream.impl.ServerInputStreamImpl;
import net.officefloor.plugin.stream.impl.ServerOutputStreamImpl;

public class TcpConnectionHandler
implements ConnectionHandler,
AsynchronousManagedObject,
WriteBufferReceiver,
ServerTcpConnection {
    private static final long NON_IDLE_SINCE_TIMESTAMP = -1L;
    private final TcpCommunicationProtocol protocol;
    private final Connection connection;
    private final long maxIdleTime;
    private final ServerInputStreamImpl inputStream;
    private final ServerOutputStreamImpl outputStream;
    private boolean isProcessStarted = false;
    private long idleSinceTimestamp = -1L;
    private AsynchronousListener asynchronousListener;

    public TcpConnectionHandler(TcpCommunicationProtocol protocol, Connection connection, int sendBufferSize, long maxIdleTime) {
        this.protocol = protocol;
        this.connection = connection;
        this.maxIdleTime = maxIdleTime;
        this.inputStream = new ServerInputStreamImpl(connection.getLock());
        this.outputStream = new ServerOutputStreamImpl(this, sendBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleHeartbeat(HeartBeatContext context) throws IOException {
        if (this.idleSinceTimestamp == -1L) {
            this.idleSinceTimestamp = context.getTime();
        } else {
            long currentTime = context.getTime();
            long idleTime = currentTime - this.idleSinceTimestamp;
            if (idleTime > this.maxIdleTime) {
                this.connection.close();
                Object object = this.getLock();
                synchronized (object) {
                    if (this.asynchronousListener != null) {
                        this.asynchronousListener.notifyComplete();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRead(ReadContext context) throws IOException {
        this.idleSinceTimestamp = -1L;
        Object object = this.getLock();
        synchronized (object) {
            byte[] data = context.getData();
            this.inputStream.inputData(data, 0, data.length - 1, true);
            if (this.asynchronousListener != null) {
                this.asynchronousListener.notifyComplete();
            }
        }
        if (!this.isProcessStarted) {
            this.protocol.serviceConnection(this);
            this.isProcessStarted = true;
        }
    }

    @Override
    public Object getLock() {
        return this.connection.getLock();
    }

    @Override
    public WriteBuffer createWriteBuffer(byte[] data, int length) {
        return this.connection.createWriteBuffer(data, length);
    }

    @Override
    public WriteBuffer createWriteBuffer(ByteBuffer buffer) {
        return this.connection.createWriteBuffer(buffer);
    }

    @Override
    public void writeData(WriteBuffer[] data) throws IOException {
        this.idleSinceTimestamp = -1L;
        this.connection.writeData(data);
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    @Override
    public boolean isClosed() {
        return this.connection.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsynchronousCompletionListener(AsynchronousListener listener) {
        Object object = this.getLock();
        synchronized (object) {
            this.asynchronousListener = listener;
        }
    }

    public Object getObject() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitOnClientData() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.inputStream.available() > 0) {
                return false;
            }
            this.asynchronousListener.notifyStarted();
            return true;
        }
    }

    @Override
    public ServerInputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public ServerOutputStream getOutputStream() {
        return this.outputStream;
    }
}

