/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.stream.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import junit.framework.TestCase;
import net.officefloor.plugin.socket.server.impl.ArrayWriteBuffer;
import net.officefloor.plugin.socket.server.impl.BufferWriteBuffer;
import net.officefloor.plugin.socket.server.protocol.WriteBuffer;
import net.officefloor.plugin.socket.server.protocol.WriteBufferEnum;
import net.officefloor.plugin.stream.ServerOutputStream;
import net.officefloor.plugin.stream.ServerWriter;
import net.officefloor.plugin.stream.WriteBufferReceiver;
import net.officefloor.plugin.stream.impl.ServerOutputStreamImpl;

public class MockServerOutputStream
implements WriteBufferReceiver {
    private static final int SEND_BUFFER_SIZE = 1024;
    private final ServerOutputStream serverOutputStream;
    private final ServerWriter serverWriter;
    private final ByteArrayOutputStream writtenBytes;
    private boolean isClosed = false;

    public MockServerOutputStream() {
        this(1024);
    }

    public MockServerOutputStream(int sendBufferSize) {
        this(sendBufferSize, Charset.defaultCharset());
    }

    public MockServerOutputStream(Charset charset) {
        this(1024, charset);
    }

    public MockServerOutputStream(int sendBufferSize, Charset charset) {
        this.serverOutputStream = new ServerOutputStreamImpl(this, sendBufferSize);
        this.serverWriter = new ServerWriter(this.serverOutputStream, charset, this);
        this.writtenBytes = new ByteArrayOutputStream(sendBufferSize);
    }

    public ServerOutputStream getServerOutputStream() {
        return this.serverOutputStream;
    }

    public ServerWriter getServerWriter() {
        return this.serverWriter;
    }

    public void flush() throws IOException {
        this.serverWriter.flush();
        this.serverOutputStream.flush();
    }

    public byte[] getWrittenBytes() {
        return this.writtenBytes.toByteArray();
    }

    @Override
    public Object getLock() {
        return this;
    }

    @Override
    public WriteBuffer createWriteBuffer(byte[] data, int length) {
        return new ArrayWriteBuffer(data, length);
    }

    @Override
    public WriteBuffer createWriteBuffer(ByteBuffer buffer) {
        return new BufferWriteBuffer(buffer);
    }

    @Override
    public void writeData(WriteBuffer[] data) {
        block6: for (WriteBuffer buffer : data) {
            WriteBufferEnum type = buffer.getType();
            switch (type) {
                case BYTE_ARRAY: {
                    this.writtenBytes.write(buffer.getData(), 0, buffer.length());
                    continue block6;
                }
                case BYTE_BUFFER: {
                    ByteBuffer bytes = buffer.getDataBuffer();
                    byte[] content = new byte[bytes.remaining()];
                    bytes.get(content);
                    try {
                        this.writtenBytes.write(content);
                        continue block6;
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException("Should not occur", ex);
                    }
                }
                default: {
                    TestCase.fail((String)("Unknown " + WriteBuffer.class.getSimpleName() + " type: " + (Object)((Object)type)));
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }
}

