/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.stream.impl;

import java.io.IOException;
import net.officefloor.plugin.stream.BrowseInputStream;
import net.officefloor.plugin.stream.NoAvailableInputException;
import net.officefloor.plugin.stream.ServerInputStream;

public class ServerInputStreamImpl
extends ServerInputStream {
    private final Object lock;
    private ReadBuffer headBuffer = null;
    private ReadBuffer tailBuffer = null;
    private int currentBufferIndex = 0;
    private int available = 0;
    private boolean isFurtherData = true;
    private BrowseInputStreamImpl browseWaitingDataHead = null;

    public ServerInputStreamImpl(Object lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputData(byte[] data, int startIndex, int endIndex, boolean isFurtherData) {
        Object object = this.lock;
        synchronized (object) {
            if (data != null) {
                ReadBuffer readBuffer = new ReadBuffer(data, startIndex, endIndex);
                if (this.tailBuffer == null) {
                    this.headBuffer = readBuffer;
                    this.tailBuffer = readBuffer;
                    this.currentBufferIndex = readBuffer.startIndex;
                } else {
                    this.tailBuffer.next = readBuffer;
                    this.tailBuffer = readBuffer;
                }
                BrowseInputStreamImpl browse = this.browseWaitingDataHead;
                while (browse != null) {
                    browse.currentBuffer = readBuffer;
                    browse.currentBufferIndex = readBuffer.startIndex;
                    browse = browse.next;
                }
                this.browseWaitingDataHead = null;
                this.available += endIndex - startIndex + 1;
            }
            this.isFurtherData = isFurtherData;
        }
    }

    @Override
    public BrowseInputStream createBrowseInputStream() {
        BrowseInputStreamImpl browse = new BrowseInputStreamImpl();
        if (browse.currentBuffer == null) {
            browse.registerForInputData();
        }
        return browse;
    }

    @Override
    public int read() throws IOException, NoAvailableInputException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.headBuffer == null) {
                    if (this.isFurtherData) {
                        throw new NoAvailableInputException();
                    }
                    return -1;
                }
                if (this.currentBufferIndex <= this.headBuffer.endIndex) {
                    --this.available;
                    return this.headBuffer.data[this.currentBufferIndex++];
                }
                this.headBuffer = this.headBuffer.next;
                if (this.headBuffer != null) {
                    this.currentBufferIndex = this.headBuffer.startIndex;
                    continue;
                }
                this.tailBuffer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.available == 0 && !this.isFurtherData ? -1 : this.available;
        }
    }

    private class BrowseInputStreamImpl
    extends BrowseInputStream {
        public ReadBuffer currentBuffer;
        public int currentBufferIndex = 0;
        public BrowseInputStreamImpl next = null;

        public BrowseInputStreamImpl() {
            this.currentBuffer = ServerInputStreamImpl.this.headBuffer;
            this.currentBufferIndex = ServerInputStreamImpl.this.currentBufferIndex;
        }

        private void registerForInputData() {
            BrowseInputStreamImpl currentWait = ServerInputStreamImpl.this.browseWaitingDataHead;
            if (currentWait == null) {
                ServerInputStreamImpl.this.browseWaitingDataHead = this;
            } else {
                BrowseInputStreamImpl previousWait = currentWait;
                currentWait = previousWait.next;
                while (currentWait != null) {
                    previousWait = currentWait;
                    currentWait = currentWait.next;
                }
                previousWait.next = this;
            }
        }

        @Override
        public int read() throws IOException, NoAvailableInputException {
            Object object = ServerInputStreamImpl.this.lock;
            synchronized (object) {
                while (true) {
                    if (this.currentBuffer == null) {
                        if (ServerInputStreamImpl.this.isFurtherData) {
                            throw new NoAvailableInputException();
                        }
                        return -1;
                    }
                    if (this.currentBufferIndex <= this.currentBuffer.endIndex) {
                        return this.currentBuffer.data[this.currentBufferIndex++];
                    }
                    this.currentBuffer = this.currentBuffer.next;
                    if (this.currentBuffer != null) {
                        this.currentBufferIndex = this.currentBuffer.startIndex;
                        continue;
                    }
                    this.registerForInputData();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            Object object = ServerInputStreamImpl.this.lock;
            synchronized (object) {
                if (this.currentBuffer != null && this.currentBufferIndex > this.currentBuffer.endIndex) {
                    this.currentBuffer = this.currentBuffer.next;
                    if (this.currentBuffer != null) {
                        this.currentBufferIndex = this.currentBuffer.startIndex;
                    }
                }
                int available = 0;
                ReadBuffer buffer = this.currentBuffer;
                while (buffer != null) {
                    available += buffer.endIndex - buffer.startIndex + 1;
                    buffer = buffer.next;
                }
                if (!ServerInputStreamImpl.this.isFurtherData && available == 0) {
                    available = -1;
                }
                return available;
            }
        }
    }

    private static class ReadBuffer {
        public final byte[] data;
        public final int startIndex;
        public final int endIndex;
        public ReadBuffer next = null;

        public ReadBuffer(byte[] data, int startIndex, int endIndex) {
            this.data = data;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }
}

