/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.stream.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.Queue;
import net.officefloor.plugin.socket.server.protocol.WriteBuffer;
import net.officefloor.plugin.stream.ServerOutputStream;
import net.officefloor.plugin.stream.WriteBufferReceiver;

public class ServerOutputStreamImpl
extends ServerOutputStream {
    private final WriteBufferReceiver receiver;
    private final int sendBufferSize;
    private byte[] currentData;
    private int nextCurrentDataIndex = 0;
    private final Queue<WriteBuffer> dataToWrite = new LinkedList<WriteBuffer>();

    public ServerOutputStreamImpl(WriteBufferReceiver receiver, int sendBufferSize) {
        this.receiver = receiver;
        this.sendBufferSize = sendBufferSize;
    }

    private void ensureNotClosed() throws ClosedChannelException {
        if (this.receiver.isClosed()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        Object object = this.receiver.getLock();
        synchronized (object) {
            this.currentData = null;
            this.dataToWrite.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuffer cachedBuffer) throws IOException {
        Object object = this.receiver.getLock();
        synchronized (object) {
            WriteBuffer buffer;
            if (this.currentData != null) {
                buffer = this.receiver.createWriteBuffer(this.currentData, this.nextCurrentDataIndex);
                this.dataToWrite.add(buffer);
                this.currentData = null;
            }
            buffer = this.receiver.createWriteBuffer(cachedBuffer);
            this.dataToWrite.add(buffer);
        }
    }

    @Override
    public void write(int b) throws IOException {
        Object object = this.receiver.getLock();
        synchronized (object) {
            this.ensureNotClosed();
            while (true) {
                if (this.currentData == null) {
                    this.currentData = new byte[this.sendBufferSize];
                    this.currentData[0] = (byte)b;
                    this.nextCurrentDataIndex = 1;
                    return;
                }
                if (this.nextCurrentDataIndex < this.currentData.length) {
                    this.currentData[this.nextCurrentDataIndex++] = (byte)b;
                    return;
                }
                this.dataToWrite.add(this.receiver.createWriteBuffer(this.currentData, this.currentData.length));
                this.currentData = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.receiver.getLock();
        synchronized (object) {
            this.ensureNotClosed();
            int dataToWriteSize = this.dataToWrite.size();
            boolean isCurrentData = this.currentData != null;
            int buffersToWrite = dataToWriteSize + (isCurrentData ? 1 : 0);
            if (buffersToWrite == 0) {
                return;
            }
            WriteBuffer[] buffers = new WriteBuffer[buffersToWrite];
            for (int i = 0; i < dataToWriteSize; ++i) {
                buffers[i] = this.dataToWrite.poll();
            }
            if (isCurrentData) {
                buffers[buffers.length - 1] = this.receiver.createWriteBuffer(this.currentData, this.nextCurrentDataIndex);
            }
            this.currentData = null;
            this.dataToWrite.clear();
            this.receiver.writeData(buffers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.receiver.getLock();
        synchronized (object) {
            if (this.receiver.isClosed()) {
                return;
            }
            this.flush();
            this.receiver.close();
        }
    }
}

