/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import org.jetbrains.annotations.NotNull;

public class BinaryLongReference
extends AbstractReference
implements LongReference {
    public static final long LONG_NOT_COMPLETE = -1L;

    @Override
    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        super.bytesStore(bytes, offset, length);
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @NotNull
    public String toString() {
        return this.bytes == null ? "bytes is null" : "value: " + this.getValue();
    }

    public long getValue() {
        return this.bytes == null ? 0L : this.bytes.readLong(this.offset);
    }

    public void setValue(long value) {
        try {
            this.bytes.writeLong(this.offset, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public long getVolatileValue() {
        try {
            return this.bytes.readVolatileLong(this.offset);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public void setVolatileValue(long value) {
        try {
            this.bytes.writeVolatileLong(this.offset, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public long getVolatileValue(long closedValue) {
        if (this.isClosed()) {
            return closedValue;
        }
        try {
            return this.getVolatileValue();
        }
        catch (Exception e) {
            return closedValue;
        }
    }

    public void setOrderedValue(long value) {
        try {
            this.bytes.writeOrderedLong(this.offset, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public long addValue(long delta) {
        try {
            return this.bytes.addAndGetLong(this.offset, delta);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public long addAtomicValue(long delta) {
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(long expected, long value) {
        try {
            return this.bytes.compareAndSwapLong(this.offset, expected, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }
}

