/*
 * Decompiled with CFR 0.152.
 */
package com.ld.zxw.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ld.zxw.config.LuceneDataSource;
import com.ld.zxw.config.LucenePlusConfig;
import com.ld.zxw.core.LucenePlugin;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.wltea.analyzer.lucene.IKAnalyzer;

public class LucenePlus {
    private Logger log = Logger.getLogger(LucenePlugin.class);
    public List<Map<String, LucenePlusConfig>> list = Lists.newArrayList();

    public void putDataSource(LucenePlusConfig lucenePlusConfig, String sourceKey) {
        HashMap map = Maps.newHashMap();
        map.put(sourceKey, lucenePlusConfig);
        this.list.add(map);
    }

    public boolean start() {
        try {
            int size = this.list.size();
            for (int i = 0; i < size; ++i) {
                Map<String, LucenePlusConfig> map = this.list.get(i);
                for (Map.Entry<String, LucenePlusConfig> entry : map.entrySet()) {
                    String key = entry.getKey();
                    LucenePlusConfig config = entry.getValue();
                    if (config.getAnalyzer() == null) {
                        config.setAnalyzer(new PerFieldAnalyzerWrapper((Analyzer)new IKAnalyzer(false, config)));
                    }
                    LucenePlusConfig plusConfig = new LucenePlusConfig();
                    plusConfig.setAnalyzer(config.getAnalyzer());
                    plusConfig.setLucenePath(config.getLucenePath());
                    plusConfig.setHighlight(config.isHighlight());
                    plusConfig.setHighlightConf(config.getHighlightConf());
                    plusConfig.setBoostField(config.getBoostField());
                    plusConfig.setParticipleField(config.getParticipleField());
                    plusConfig.setHighlightFields(config.getHighlightFields());
                    this.setPath(key, plusConfig);
                    this.setIndexWriter(plusConfig);
                    this.setIndexSearcher(plusConfig);
                    LuceneDataSource.build().dataSource.put(key, plusConfig);
                }
            }
            this.log.info((Object)"LucenePlus \u52a0\u8f7d\u5b8c\u6bd5!");
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"LucenePlugin.start()", (Throwable)e);
            return false;
        }
    }

    public void setIndexSearcher(LucenePlusConfig LucenePlusConfig2) {
        DirectoryReader open = null;
        try {
            open = DirectoryReader.open((IndexWriter)LucenePlusConfig2.getIndexWriter());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IndexSearcher searcher = new IndexSearcher((IndexReader)open);
        LucenePlusConfig2.setIndexSearcher(searcher);
    }

    public void setIndexWriter(LucenePlusConfig LucenePlusConfig2) {
        IndexWriter indexWriter = null;
        try {
            indexWriter = new IndexWriter((Directory)FSDirectory.open((Path)LucenePlusConfig2.getPath(), (LockFactory)NoLockFactory.INSTANCE), new IndexWriterConfig((Analyzer)LucenePlusConfig2.getAnalyzer()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LucenePlusConfig2.setIndexWriter(indexWriter);
    }

    public void setPath(String sourceKey, LucenePlusConfig conf) {
        try {
            String lucene_core = conf.getLucenePath() + sourceKey + "/data";
            File file = new File(lucene_core);
            if (!file.isDirectory()) {
                file.mkdirs();
            }
            Path path = Paths.get(lucene_core, new String[0]);
            conf.setPath(path);
        }
        catch (Exception e) {
            this.log.error((Object)"LucenePlugin.setPath()", (Throwable)e);
        }
    }

    public boolean stop() {
        Map<String, LucenePlusConfig> dataSource = LuceneDataSource.build().dataSource;
        for (Map.Entry<String, LucenePlusConfig> entry : dataSource.entrySet()) {
            this.log.info((Object)("\u5173\u95ed\u7d22\u5f15\u6e90:" + entry.getKey()));
            this.close(entry.getValue().getIndexWriter(), true);
        }
        return true;
    }

    public boolean commit() {
        Map<String, LucenePlusConfig> dataSource = LuceneDataSource.build().dataSource;
        for (Map.Entry<String, LucenePlusConfig> entry : dataSource.entrySet()) {
            this.close(entry.getValue().getIndexWriter(), false);
        }
        return true;
    }

    public static boolean commiT() {
        Map<String, LucenePlusConfig> dataSource = LuceneDataSource.build().dataSource;
        for (Map.Entry<String, LucenePlusConfig> entry : dataSource.entrySet()) {
            System.out.println("\u624b\u52a8\u63d0\u4ea4\u6570\u636e\u6e90:" + entry.getKey());
            LucenePlus plus = new LucenePlus();
            plus.close(entry.getValue().getIndexWriter(), false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(IndexWriter writer, boolean flag) {
        try {
            writer.commit();
        }
        catch (Exception e) {
            try {
                writer.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        finally {
            if (flag) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

