/*
 * Decompiled with CFR 0.152.
 */
package com.ld.zxw.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ld.zxw.Documents.Documents;
import com.ld.zxw.config.LuceneDataSource;
import com.ld.zxw.config.LucenePlusConfig;
import com.ld.zxw.util.BoostDto;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.FSDirectory;

public class CommonUtil {
    private static Logger log = Logger.getLogger(CommonUtil.class);

    public static void colseIndexWriter(IndexWriter indexWriter) {
        if (indexWriter != null) {
            try {
                indexWriter.close();
            }
            catch (IOException e) {
                log.error((Object)"colseIndexWriter", (Throwable)e);
            }
        }
    }

    public static void colseDirectory(FSDirectory fsd) {
        if (fsd != null) {
            try {
                fsd.close();
            }
            catch (Exception e) {
                log.error((Object)"colseDirectory", (Throwable)e);
            }
        }
    }

    public static void colseDirectoryReader(DirectoryReader dir) {
        if (dir != null) {
            try {
                dir.close();
            }
            catch (IOException e) {
                log.error((Object)"colseDirectoryReader", (Throwable)e);
            }
        }
    }

    public static synchronized <T> List<Document> turnDoc(List<T> objs, LucenePlusConfig lucenePlusConfig) {
        ArrayList documents = Lists.newArrayList();
        Map<String, Float> boostField = lucenePlusConfig.getBoostField();
        int size = objs.size();
        for (int i = 0; i < size; ++i) {
            documents.add(CommonUtil.objDoc(objs.get(i), boostField, lucenePlusConfig.getParticipleField()));
        }
        return documents;
    }

    public static synchronized <T> Document turnDoc(T obj, LucenePlusConfig lucenePlusConfig) {
        Map<String, Float> boostField = lucenePlusConfig.getBoostField();
        return CommonUtil.objDoc(obj, boostField, lucenePlusConfig.getParticipleField());
    }

    public static synchronized Document objDoc(Object obj, Map<String, Float> boost, List<String> queryfields) {
        Documents doc = new Documents();
        Field[] fields = obj.getClass().getDeclaredFields();
        List<BoostDto> list = CommonUtil.getBoosts();
        if (list == null || list.size() < 1) {
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                field.setAccessible(true);
                String name = field.getName();
                String type = field.getType().getName();
                Object val = new Object();
                try {
                    val = field.get(obj);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (boost != null) {
                    doc.put(name, val, CommonUtil.getType(name, type, queryfields), boost.get(name).floatValue());
                    continue;
                }
                doc.put(name, val, CommonUtil.getType(name, type, queryfields), 1.0f);
            }
        } else {
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                field.setAccessible(true);
                String name = field.getName();
                String type = field.getType().getName();
                Object val = new Object();
                try {
                    val = field.get(obj);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                doc.put(name, val, type, boost.get(name).floatValue() + CommonUtil.getBoost(name, list));
            }
        }
        return doc.getDocument();
    }

    public static synchronized String getType(String name, String type, List<String> fields) {
        String typeName = null;
        String[] split = type.split("\\.");
        typeName = split.length > 1 ? split[split.length - 1] : type;
        if (fields != null && fields.contains(name)) {
            typeName = "text";
        }
        return typeName.toLowerCase();
    }

    public static synchronized float getBoost(String name, List<BoostDto> boosts) {
        int size = boosts.size();
        float k = 0.0f;
        for (int i = 0; i < size; ++i) {
            BoostDto boostDto = boosts.get(i);
            if (!boostDto.equals(name)) continue;
            k = boostDto.getBoost();
            boosts.remove(i);
            break;
        }
        return k;
    }

    public static synchronized String IllegalFiltering(String str, String filter) {
        if (filter != null) {
            return str;
        }
        char[] data = CommonUtil.getChar(str);
        char[] fiter = CommonUtil.getChar(filter);
        String key = "";
        for (int i = 0; i < data.length; ++i) {
            if (!CommonUtil.isFlag(fiter, data[i])) continue;
            key = key + String.valueOf(data[i]);
        }
        return key;
    }

    private static char[] getChar(String str) {
        char[] c = new char[str.length()];
        c = str.toCharArray();
        return c;
    }

    public static boolean isFlag(char[] fiter, char vue) {
        boolean flag = true;
        for (int j = 0; j < fiter.length; ++j) {
            if (fiter[j] != vue) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static List<BoostDto> getBoosts() {
        if (LuceneDataSource.build().jedis == null) {
            return null;
        }
        List lrange = LuceneDataSource.build().jedis.lrange("LuceneBoost_LD", 0L, Integer.MAX_VALUE);
        return CommonUtil.orObj(lrange);
    }

    public static List<BoostDto> orObj(List<String> list) {
        ArrayList dtos = Lists.newArrayList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            dtos.add(JSONObject.parseObject((String)list.get(i), BoostDto.class));
        }
        return dtos;
    }

    public static synchronized void refresh(LucenePlusConfig lucenePlusConfig, IndexWriter writer) {
        DirectoryReader reader = null;
        try {
            reader = DirectoryReader.open((IndexWriter)writer);
        }
        catch (IOException e) {
            log.error((Object)"refresh-error", (Throwable)e);
        }
        lucenePlusConfig.setIndexSearcher(new IndexSearcher((IndexReader)reader));
        if (!lucenePlusConfig.getDevMode()) {
            try {
                writer.commit();
            }
            catch (Exception e) {
                try {
                    writer.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                log.error((Object)"writer.commit-error", (Throwable)e);
            }
        }
    }
}

