/*
 * Decompiled with CFR 0.152.
 */
package com.ld.zxw.util;

import com.ld.zxw.util.BigDecimalUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public final class DateUtil {
    private static final Logger log = Logger.getLogger(DateUtil.class);

    private DateUtil() {
    }

    public static long getTime() {
        return new Date().getTime();
    }

    public static void timeConsuming(String name, long time) {
        long v = DateUtil.getTime() - time;
        log.info((Object)(name + "--->\u6267\u884c\u8017\u65f6:" + BigDecimalUtil.divide(v, 1000.0) + "  \u79d2"));
        log.info((Object)(name + "--->\u6267\u884c\u8017\u65f6:" + v + "  \u6beb\u79d2"));
    }

    public static final String format(Object date) {
        return DateUtil.format(date, "yyyy-MM-dd");
    }

    public static final String format(Object date, String pattern) {
        if (date == null) {
            return null;
        }
        if (pattern == null) {
            return DateUtil.format(date);
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static final String getDate() {
        return DateUtil.format(new Date());
    }

    public static final String getDateTime() {
        return DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static final String getDateTime(String pattern) {
        return DateUtil.format(new Date(), pattern);
    }

    public static final Date addDate(Date date, int field, int amount) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static final Date stringToDate(String date) {
        if (date == null) {
            return null;
        }
        String separator = String.valueOf(date.charAt(4));
        String pattern = "yyyyMMdd";
        if (!separator.matches("\\d*")) {
            pattern = "yyyy" + separator + "MM" + separator + "dd";
            if (date.length() < 10) {
                pattern = "yyyy" + separator + "M" + separator + "d";
            }
        } else if (date.length() < 8) {
            pattern = "yyyyMd";
        }
        pattern = pattern + " HH:mm:ss.SSS";
        pattern = pattern.substring(0, Math.min(pattern.length(), date.length()));
        try {
            return new SimpleDateFormat(pattern).parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static final Integer getDayBetween(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        start.set(11, 0);
        start.set(12, 0);
        start.set(13, 0);
        start.set(14, 0);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        end.set(11, 0);
        end.set(12, 0);
        end.set(13, 0);
        end.set(14, 0);
        long n = end.getTimeInMillis() - start.getTimeInMillis();
        return (int)(n / 86400000L);
    }

    public static final Integer getMonthBetween(Date startDate, Date endDate) {
        if (startDate == null || endDate == null || !startDate.before(endDate)) {
            return null;
        }
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        int year1 = start.get(1);
        int year2 = end.get(1);
        int month1 = start.get(2);
        int month2 = end.get(2);
        int n = (year2 - year1) * 12;
        n = n + month2 - month1;
        return n;
    }

    public static final Integer getMonthBetweenWithDay(Date startDate, Date endDate) {
        if (startDate == null || endDate == null || !startDate.before(endDate)) {
            return null;
        }
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        int year1 = start.get(1);
        int year2 = end.get(1);
        int month1 = start.get(2);
        int month2 = end.get(2);
        int n = (year2 - year1) * 12;
        n = n + month2 - month1;
        int day1 = start.get(5);
        int day2 = end.get(5);
        if (day1 <= day2) {
            ++n;
        }
        return n;
    }

    public static interface DATE_PATTERN {
        public static final String HHMMSS = "HHmmss";
        public static final String HH_MM_SS = "HH:mm:ss";
        public static final String YYYYMMDD = "yyyyMMdd";
        public static final String YYYY_MM_DD = "yyyy-MM-dd";
        public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
        public static final String YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";
        public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    }
}

