/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.lucene;

import com.ld.zxw.config.LucenePlusConfig;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.wltea.analyzer.lucene.IKTokenizer;

public final class IKAnalyzer
extends Analyzer {
    private boolean useSmart;
    private LucenePlusConfig lucenePlusConfig;

    public boolean useSmart() {
        return this.useSmart;
    }

    public void setUseSmart(boolean useSmart) {
        this.useSmart = useSmart;
    }

    public IKAnalyzer() {
        this(false);
    }

    public IKAnalyzer(boolean useSmart) {
        this.useSmart = useSmart;
    }

    public IKAnalyzer(boolean useSmart, LucenePlusConfig lucenePlusConfig) {
        this.useSmart = false;
        this.lucenePlusConfig = lucenePlusConfig;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StringReader reader = new StringReader(fieldName);
        IKTokenizer ikTokenizer = new IKTokenizer(reader, this.useSmart, this.lucenePlusConfig);
        return new Analyzer.TokenStreamComponents((Tokenizer)ikTokenizer);
    }
}

