/*
 * Decompiled with CFR 0.152.
 */
package net.saliman.gradle.plugin.cobertura.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildFirstUrlClassLoader
extends URLClassLoader {
    private ClassLoader system = ChildFirstUrlClassLoader.getSystemClassLoader();

    public ChildFirstUrlClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (this.system != null) {
                try {
                    c = this.system.loadClass(name);
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
            }
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.system != null) {
            url = this.system.getResource(name);
        }
        if (url == null && (url = this.findResource(name)) == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> systemUrls = null;
        if (this.system != null) {
            systemUrls = this.system.getResources(name);
        }
        Enumeration<URL> localUrls = this.findResources(name);
        Enumeration<URL> parentUrls = null;
        if (this.getParent() != null) {
            parentUrls = this.getParent().getResources(name);
        }
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (systemUrls != null) {
            while (systemUrls.hasMoreElements()) {
                urls.add(systemUrls.nextElement());
            }
        }
        if (localUrls != null) {
            while (localUrls.hasMoreElements()) {
                urls.add(localUrls.nextElement());
            }
        }
        if (parentUrls != null) {
            while (parentUrls.hasMoreElements()) {
                urls.add(parentUrls.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

