/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.AsciiInputStream;
import gnu.inet.ftp.ConnectionEvent;
import gnu.inet.ftp.Getter;
import gnu.inet.ftp.PassiveConnection;
import gnu.inet.ftp.PassiveParameters;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.zip.InflaterInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PassiveGetter
extends Getter {
    private PassiveConnection connection;
    private Socket sock = null;
    private static final Log log = LogFactory.getLog((Class)PassiveGetter.class);

    public PassiveGetter(OutputStream out, PassiveConnection connection) {
        this.ostream = out;
        this.connection = connection;
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.interrupt();
            if (this.sock != null && !this.sock.isClosed()) {
                try {
                    log.debug((Object)"Setting socket to 0 lingering");
                    this.sock.setSoLinger(true, 0);
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        PassiveParameters parameters;
        boolean signalClosure;
        block32: {
            signalClosure = false;
            InputStream istream = null;
            long amount = 0L;
            int buffer_size = 0;
            byte[] buffer = new byte[1024];
            parameters = this.connection.getPassiveParameters();
            try {
                this.sock = this.connection.getSocket();
                if (this.cancelled) {
                    throw new InterruptedIOException("Transfer cancelled");
                }
                this.signalConnectionOpened(new ConnectionEvent(parameters.getInetAddress(), parameters.getPort()));
                signalClosure = true;
                this.signalTransferStarted();
                try {
                    int len;
                    switch (this.type) {
                        case 'A': {
                            istream = new AsciiInputStream(this.sock.getInputStream());
                            break;
                        }
                        default: {
                            istream = this.sock.getInputStream();
                        }
                    }
                    switch (this.mode) {
                        case 'Z': {
                            istream = new InflaterInputStream(istream);
                            break;
                        }
                    }
                    while (!this.cancelled && (len = istream.read(buffer)) > 0) {
                        this.ostream.write(buffer, 0, len);
                        amount += (long)len;
                        if ((buffer_size += len) >= 1024) {
                            buffer_size %= 1024;
                            this.signalTransfered(amount);
                        }
                        PassiveGetter.yield();
                    }
                    this.ostream.flush();
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    log.debug((Object)"Closing inputstream");
                    if (istream != null) {
                        istream.close();
                    }
                    if (!this.sock.isClosed()) {
                        try {
                            log.debug((Object)"Setting socket to 0 lingering");
                            this.sock.setSoLinger(true, 0);
                            this.sock.close();
                        }
                        catch (SocketException e2) {
                            // empty catch block
                        }
                    }
                    this.signalTransferCompleted();
                    throw throwable;
                }
                log.debug((Object)"Closing inputstream");
                if (istream != null) {
                    istream.close();
                }
                if (!this.sock.isClosed()) {
                    try {
                        log.debug((Object)"Setting socket to 0 lingering");
                        this.sock.setSoLinger(true, 0);
                        this.sock.close();
                    }
                    catch (SocketException e2) {
                        // empty catch block
                    }
                }
                this.signalTransferCompleted();
                {
                    break block32;
                    catch (InterruptedIOException iioe) {
                        if (!this.cancelled) {
                            log.error((Object)iioe.getMessage(), (Throwable)iioe);
                        }
                        Object var10_12 = null;
                        log.debug((Object)"Closing inputstream");
                        if (istream != null) {
                            istream.close();
                        }
                        if (!this.sock.isClosed()) {
                            try {
                                log.debug((Object)"Setting socket to 0 lingering");
                                this.sock.setSoLinger(true, 0);
                                this.sock.close();
                            }
                            catch (SocketException e2) {
                                // empty catch block
                            }
                        }
                        this.signalTransferCompleted();
                        break block32;
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        Object var10_13 = null;
                        log.debug((Object)"Closing inputstream");
                        if (istream != null) {
                            istream.close();
                        }
                        if (!this.sock.isClosed()) {
                            try {
                                log.debug((Object)"Setting socket to 0 lingering");
                                this.sock.setSoLinger(true, 0);
                                this.sock.close();
                            }
                            catch (SocketException e2) {
                                // empty catch block
                            }
                        }
                        this.signalTransferCompleted();
                    }
                }
            }
            catch (Exception ee) {
                this.signalConnectionFailed(ee);
                log.error((Object)ee.getMessage(), (Throwable)ee);
            }
        }
        if (signalClosure) {
            this.signalConnectionClosed(new ConnectionEvent(parameters.getInetAddress(), parameters.getPort()));
        }
        this.sock = null;
    }
}

