/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.util;

import gnu.hylafax.HylaFAXClient;
import gnu.hylafax.Job;
import gnu.hylafax.Pagesize;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendFax2 {
    private static final Log log = LogFactory.getLog((Class)SendFax2.class);
    private static Options options = new Options();
    private static HelpFormatter hf = new HelpFormatter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block35: {
            String[] files;
            String user = "fax";
            String host = "localhost";
            String destination = null;
            String from = user;
            String killtime = "000259";
            int maxdials = 12;
            int maxtries = 3;
            int priority = 127;
            String notifyaddr = user;
            int resolution = 98;
            String notify = "none";
            String pagechop = "default";
            int chopthreshold = 3;
            Vector<String> documents = new Vector<String>();
            boolean verbose = false;
            boolean from_is_set = false;
            Pagesize pagesize = Pagesize.LETTER;
            OptionBuilder.withArgName((String)"user");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"user to login to the server with");
            Option u = OptionBuilder.create((char)'u');
            OptionBuilder.withArgName((String)"host");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"specify the fax server hostname");
            Option h = OptionBuilder.create((char)'h');
            OptionBuilder.withArgName((String)"number");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"specify a destination FAX <number>");
            Option d = OptionBuilder.create((char)'d');
            OptionBuilder.withArgName((String)"sender");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"user <sender> as the identity of the FAX sender");
            Option f = OptionBuilder.create((char)'f');
            OptionBuilder.withArgName((String)"time");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"kill the job if it doesn't complete after the indicated <time> (default: \"000259\", 2 hours, 59 minutes)");
            Option k = OptionBuilder.create((char)'k');
            OptionBuilder.withArgName((String)"dials");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"maximum number of <dials> to attempt for each job (default: 12)");
            Option T = OptionBuilder.create((char)'T');
            OptionBuilder.withArgName((String)"tries");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"make no more than <tries> attempts to deliver the FAX (default: 3)");
            Option t = OptionBuilder.create((char)'t');
            OptionBuilder.withArgName((String)"priority");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"assign the <priority> priority to the job (default: 127)");
            Option P = OptionBuilder.create((char)'P');
            OptionBuilder.withArgName((String)"size");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"specify the symbolic page <size> (legal, us-let, a3, a4, etc.)");
            Option s = OptionBuilder.create((char)'s');
            OptionBuilder.withDescription((String)"use low resolution (98 dpi)");
            Option l = OptionBuilder.create((char)'l');
            OptionBuilder.withDescription((String)"use medium resolution (196 dpi)");
            Option m = OptionBuilder.create((char)'m');
            OptionBuilder.withDescription((String)"set verbose mode");
            Option v = OptionBuilder.create((char)'v');
            OptionBuilder.withDescription((String)"enable delivery notification");
            Option D = OptionBuilder.create((char)'D');
            OptionBuilder.withDescription((String)"enable delivery and retry notification");
            Option R = OptionBuilder.create((char)'R');
            OptionBuilder.withDescription((String)"disable delivery and retry notification");
            Option N = OptionBuilder.create((char)'N');
            options.addOption(u);
            options.addOption(h);
            options.addOption(d);
            options.addOption(f);
            options.addOption(k);
            options.addOption(T);
            options.addOption(t);
            options.addOption(P);
            options.addOption(l);
            options.addOption(m);
            options.addOption(s);
            options.addOption(v);
            options.addOption(D);
            options.addOption(R);
            options.addOption(N);
            HylaFAXClient c = new HylaFAXClient();
            GnuParser parser = new GnuParser();
            CommandLine line = null;
            try {
                line = parser.parse(options, args);
            }
            catch (ParseException ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            Iterator it = line.iterator();
            block28: while (it.hasNext()) {
                Option o = (Option)it.next();
                switch (o.getOpt().charAt(0)) {
                    case 'd': {
                        destination = o.getValue();
                        continue block28;
                    }
                    case 'f': {
                        from_is_set = true;
                        from = o.getValue();
                        continue block28;
                    }
                    case 'k': {
                        killtime = o.getValue();
                        continue block28;
                    }
                    case 'h': {
                        host = o.getValue();
                        continue block28;
                    }
                    case 'l': {
                        resolution = 98;
                        continue block28;
                    }
                    case 'm': {
                        resolution = 196;
                        continue block28;
                    }
                    case 't': {
                        maxtries = Integer.parseInt(o.getValue());
                        continue block28;
                    }
                    case 'T': {
                        maxdials = Integer.parseInt(o.getValue());
                        continue block28;
                    }
                    case 'D': {
                        notify = "DONE";
                        continue block28;
                    }
                    case 'R': {
                        notify = "REQUEUE";
                        continue block28;
                    }
                    case 'N': {
                        notify = "NONE";
                        continue block28;
                    }
                    case 'P': {
                        priority = Integer.parseInt(o.getValue());
                        continue block28;
                    }
                    case 's': {
                        pagesize = Pagesize.getPagesize((String)o.getValue());
                        if (pagesize != null) continue block28;
                        System.err.println(o.getValue() + " is not a valid pagesize value");
                        SendFax2.usage();
                        System.exit(-1);
                        continue block28;
                    }
                    case 'u': {
                        user = o.getValue();
                        continue block28;
                    }
                    case 'v': {
                        verbose = true;
                        continue block28;
                    }
                    case '?': {
                        SendFax2.usage();
                        System.exit(-1);
                        continue block28;
                    }
                }
                SendFax2.usage();
                System.exit(-1);
            }
            if (!from_is_set) {
                from = user;
            }
            if (destination == null) {
                System.err.println("A destination fax number is required.");
                SendFax2.usage();
                System.exit(-1);
            }
            if ((files = line.getArgs()).length < 1) {
                System.err.println("No files specified.");
                SendFax2.usage();
                System.exit(-1);
            }
            c.open(host);
            if (c.user(user)) {
                System.out.print("Password:");
                BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                String password = input.readLine();
                c.pass(password);
            }
            c.noop();
            c.tzone("LOCAL");
            for (int i = 0; i < files.length; ++i) {
                FileInputStream file = new FileInputStream(files[i]);
                String remote_filename = c.putTemporary((InputStream)file);
                documents.addElement(remote_filename);
            }
            Job job = c.createJob();
            job.setFromUser(from);
            job.setNotifyAddress(from);
            job.setKilltime(killtime);
            job.setMaximumDials(maxdials);
            job.setMaximumTries(maxtries);
            job.setPriority(priority);
            job.setDialstring(destination);
            job.setVerticalResolution(resolution);
            job.setPageDimension((Dimension)pagesize);
            job.setNotifyType(notify);
            job.setChopThreshold(chopthreshold);
            for (int i = 0; i < documents.size(); ++i) {
                String document = (String)documents.elementAt(i);
                job.addDocument(document);
            }
            c.submit(job);
            Object var43_46 = null;
            try {
                c.quit();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
            break block35;
            {
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    Object var43_47 = null;
                    try {
                        c.quit();
                    }
                    catch (Exception e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var43_48 = null;
                try {
                    c.quit();
                }
                catch (Exception e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    public static void usage() {
        hf.printHelp("SendFax <options> file1 ...", null, options, "Files queued must be formats that the HylaFAX server can handle natively (PS, TIFF, etc.) as no client-side conversions are performed.");
    }
}

