/*
 * JasperReports - Free Java Reporting Library.
 * Copyright (C) 2001 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of JasperReports.
 *
 * JasperReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JasperReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with JasperReports. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.jasperreports.engine.scriptlets;

import java.util.List;

import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRException;

/**
 * A factory of {@link JRAbstractScriptlet} instances.
 * 
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: ScriptletFactory.java 4386 2011-06-07 09:26:08Z shertage $
 */
public interface ScriptletFactory
{

	/**
	 * Returns a list of scriptlet instances to be used during report filling.
	 * This method can return <code>null</code> if no scriplet is to be used.
	 */
	List<JRAbstractScriptlet> getScriplets(ScriptletFactoryContext context) throws JRException;
	
}
