/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.barbecue;

import net.sf.jasperreports.barbecue.BarbecueComponent;
import net.sf.jasperreports.barbecue.BarbecueRendererImpl;
import net.sf.jasperreports.barbecue.BarbecueStyleResolver;
import net.sf.jasperreports.barbecue.BarcodeInfo;
import net.sf.jasperreports.barbecue.BarcodeProviders;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.component.ComponentDesignConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.renderers.Renderable;
import net.sourceforge.barbecue.Barcode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BarbecueDesignConverter
implements ComponentDesignConverter {
    private static final Log log = LogFactory.getLog(BarbecueDesignConverter.class);
    private static final String DEFAULT_PREVIEW_CODE = "01234567890";

    public JRPrintElement convert(ReportConverter reportConverter, JRComponentElement element) {
        BarbecueComponent component = (BarbecueComponent)element.getComponent();
        if (component == null || component.getType() == null) {
            return null;
        }
        try {
            JRBasePrintImage image = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
            reportConverter.copyBaseAttributes((JRElement)element, (JRPrintElement)image);
            image.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
            String code = null;
            if (component.getCodeExpression() != null) {
                code = JRExpressionUtil.getSimpleExpressionText((JRExpression)component.getCodeExpression());
            }
            if (code == null) {
                code = DEFAULT_PREVIEW_CODE;
            }
            String applicationIdentifier = null;
            if (component.getApplicationIdentifierExpression() != null) {
                applicationIdentifier = JRExpressionUtil.getSimpleExpressionText((JRExpression)component.getApplicationIdentifierExpression());
            }
            BarcodeInfo barcodeInfo = new BarcodeInfo();
            barcodeInfo.setType(component.getType());
            barcodeInfo.setCode(code);
            barcodeInfo.setApplicationIdentifier(applicationIdentifier);
            barcodeInfo.setDrawText(component.isDrawText());
            barcodeInfo.setRequiresChecksum(component.isChecksumRequired());
            barcodeInfo.setBarWidth(component.getBarWidth());
            barcodeInfo.setBarHeight(component.getBarHeight());
            Barcode barcode = BarcodeProviders.createBarcode(barcodeInfo);
            BarbecueRendererImpl renderer = new BarbecueRendererImpl(barcode);
            renderer.setRotation(BarbecueStyleResolver.getRotation(element));
            image.setRenderer((Renderable)renderer);
            return image;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error while previewing barcode", (Throwable)e);
            }
            return null;
        }
    }
}

