/*******************************************************************************
 * Copyright (c) 2007, 2014 Massimiliano Ziccardi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package it.jnrpe;

/**
 * An interface containing only the JNRPE version number.
 * 
 * @author Massimiliano Ziccardi
 * 
 */
public final class JNRPELIB {

	/**
	 * Private constructor to avoid instantiation.
	 */
	private JNRPELIB() {

	}

	/**
	 * The JNRPE Version as read from its manifest.
	 */
	public static final String VERSION = "JNRPE library V. "
			+ JNRPELIB.class.getPackage().getImplementationVersion();
}
