/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.reader;

import java.io.IOException;
import java.io.Reader;

public class SizeLimitReader
extends Reader {
    private boolean closed = false;
    protected long currentPosition = 0L;
    protected Reader in;
    protected long markPosition = 0L;
    protected final long maxSize;

    public SizeLimitReader(Reader in, long maxCharacterSize) {
        this.in = in;
        this.maxSize = maxCharacterSize;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
        }
    }

    public long getBytesLeft() {
        return this.maxSize - this.currentPosition;
    }

    public long getBytesRead() {
        return this.currentPosition;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void mark(int readlimit) throws IOException {
        this.in.mark(readlimit);
        this.markPosition = this.currentPosition;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        int result;
        if (this.currentPosition >= this.maxSize) {
            result = -1;
        } else {
            result = this.in.read();
            if (result >= 0) {
                ++this.currentPosition;
            }
        }
        return result;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int bytesReaded;
        if (this.currentPosition >= this.maxSize) {
            bytesReaded = -1;
        } else {
            int n = (int)Math.min(this.getBytesLeft(), (long)len);
            bytesReaded = this.in.read(cbuf, off, n);
            if (bytesReaded > 0) {
                this.currentPosition += (long)bytesReaded;
            }
        }
        return bytesReaded;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.currentPosition = this.markPosition;
        this.markPosition = 0L;
    }

    @Override
    public long skip(long n) throws IOException {
        long result;
        if (this.currentPosition >= this.maxSize) {
            result = -1L;
        } else {
            result = this.in.skip(Math.min(n, this.getBytesLeft()));
            if (result > 0L) {
                this.currentPosition += result;
            }
        }
        return result;
    }
}

