/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.store;

import com.gc.iotools.stream.store.SeekableStore;

public class MemoryStore
implements SeekableStore {
    private byte[] buffer = new byte[0];
    private long position = 0L;

    @Override
    public void cleanup() {
        this.buffer = new byte[0];
        this.position = 0L;
    }

    @Override
    public int get(byte[] bytes, int offset, int length) {
        int result;
        int effectiveLength = (int)Math.min((long)length, (long)this.buffer.length - this.position);
        if (effectiveLength > 0) {
            System.arraycopy(this.buffer, (int)this.position, bytes, offset, effectiveLength);
            result = effectiveLength;
            this.position += (long)effectiveLength;
        } else {
            result = -1;
        }
        return result;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public void put(byte[] bytes, int offset, int length) {
        byte[] tmpBuffer = new byte[length + this.buffer.length];
        System.arraycopy(this.buffer, 0, tmpBuffer, 0, this.buffer.length);
        System.arraycopy(bytes, offset, tmpBuffer, this.buffer.length, length);
        this.buffer = tmpBuffer;
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[pos=" + this.position + ",size=" + this.buffer.length + "]";
    }
}

