/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt.detect.droid;

import com.gc.iotools.fmt.base.DetectionLibrary;
import com.gc.iotools.fmt.base.FormatEnum;
import com.gc.iotools.fmt.base.FormatId;
import com.gc.iotools.fmt.base.ResettableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import uk.gov.nationalarchives.droid.base.FileFormatHit;
import uk.gov.nationalarchives.droid.binFileReader.IdentificationFile;
import uk.gov.nationalarchives.droid.binFileReader.RandomAccessByteReader;
import uk.gov.nationalarchives.droid.signatureFile.FFSignatureFile;
import uk.gov.nationalarchives.droid.signatureFile.FileFormat;
import uk.gov.nationalarchives.droid.signatureFile.InternalSignature;
import uk.gov.nationalarchives.droid.xmlReader.SAXModelBuilder;

public class DroidDetectorImpl
implements DetectionLibrary {
    private static final String SIGNATURE_FILE_NS = "http://www.nationalarchives.gov.uk/pronom/SignatureFile";
    private static final String SIGNATURE_FILE = "DROID_SignatureFile_V18.xml";
    private static final String MAPPING_FILE = "mapping.properties";
    private final Class<? extends FormatEnum> formatEnumClass;
    private static final Map<String, FFSignatureFile> CONF_MAP = new HashMap<String, FFSignatureFile>();
    private final String configFile;
    private final Properties mapping;
    private static final Logger LOG = LoggerFactory.getLogger(DroidDetectorImpl.class);

    public DroidDetectorImpl() {
        this(FormatEnum.class, SIGNATURE_FILE, MAPPING_FILE);
    }

    public DroidDetectorImpl(Class<? extends FormatEnum> formatEnumClass, String signatureFile, String mappingFileStr) {
        Class clazz;
        Class clazz2 = clazz = formatEnumClass == null ? FormatEnum.class : formatEnumClass;
        if (!FormatEnum.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(" [" + formatEnumClass + "] should be an subclass of [" + FormatEnum.class + "]");
        }
        this.formatEnumClass = clazz;
        String string = this.configFile = StringUtils.isBlank((CharSequence)signatureFile) ? SIGNATURE_FILE : signatureFile;
        if (!CONF_MAP.containsKey(this.configFile)) {
            URL confFile = DroidDetectorImpl.class.getResource(this.configFile);
            try {
                if (confFile == null || confFile.openConnection() == null) {
                    throw new IllegalArgumentException("Configuration file [" + signatureFile + "] not found or not readable.");
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Problem reading configuration file [" + signatureFile + "] url[" + confFile + "]", e);
            }
            FFSignatureFile fsigfile = this.parseSigFile(confFile);
            CONF_MAP.put(this.configFile, fsigfile);
        }
        this.mapping = new Properties();
        try {
            InputStream mappingIs = DroidDetectorImpl.class.getResourceAsStream(mappingFileStr);
            this.mapping.load(mappingIs);
            mappingIs.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't load resource[" + mappingFileStr + "]", e);
        }
    }

    @Override
    public FormatId detect(FormatEnum[] enabledFormats, ResettableInputStream stream) throws IOException {
        IdentificationFile idFile = new IdentificationFile("-");
        stream.resetToBeginning();
        RandomAccessByteReader testFile = new RandomAccessByteReader(idFile, stream);
        FFSignatureFile fsigfile = CONF_MAP.get(this.configFile);
        FFSignatureFile reduced = this.reduceDetectedSequences(fsigfile, enabledFormats);
        reduced.runFileIdentification(testFile);
        int n = testFile.getNumHits();
        FormatId fenumId = new FormatId(FormatEnum.UNKNOWN, null);
        List<FormatEnum> enabledFormatCollection = Arrays.asList(enabledFormats);
        for (int i = 0; i < n && FormatEnum.UNKNOWN.equals(fenumId.format); ++i) {
            FileFormatHit ffhit = testFile.getHit(i);
            FileFormat fileFormat = ffhit.getFileFormat();
            FormatId tmpFid = this.getFormatEnum(fileFormat);
            if (FormatEnum.UNLISTED.equals(tmpFid.format)) {
                LOG.warn("Format number[" + fileFormat.getID() + "] not found in configured mapping. format [" + fileFormat.getName() + "] was returned as [" + FormatEnum.UNLISTED + "] version[" + fileFormat.getName() + "]");
            }
            if (!enabledFormatCollection.contains(tmpFid.format)) continue;
            fenumId = tmpFid;
        }
        return fenumId;
    }

    private FFSignatureFile reduceDetectedSequences(FFSignatureFile fsig, FormatEnum[] enabled) {
        ArrayList<FileFormat> fformats = new ArrayList<FileFormat>();
        ArrayList<InternalSignature> intSigs = new ArrayList<InternalSignature>();
        ArrayList<FormatEnum> enabledColl = new ArrayList<FormatEnum>(Arrays.asList(enabled));
        HashMap<Integer, InternalSignature> internalSignatureMap = new HashMap<Integer, InternalSignature>();
        for (int i = 0; i < fsig.getNumInternalSignatures(); ++i) {
            InternalSignature intSignature = fsig.getInternalSignature(i);
            internalSignatureMap.put(intSignature.getID(), intSignature);
        }
        int n = fsig.getNumFileFormats();
        for (int i = 0; i < n; ++i) {
            FileFormat ff = fsig.getFileFormat(i);
            FormatId formatEnum = this.getFormatEnum(ff);
            if (ff.getNumInternalSignatures() <= 0 || !enabledColl.contains(formatEnum.format)) continue;
            fformats.add(ff);
            for (int j = 0; j < ff.getNumInternalSignatures(); ++j) {
                int intSigId = ff.getInternalSignatureID(j);
                InternalSignature intSig = (InternalSignature)internalSignatureMap.get(intSigId);
                if (intSig != null) {
                    intSigs.add(intSig);
                    continue;
                }
                LOG.warn("Internal signature id[" + intSig + "] not found.");
            }
        }
        return new FFSignatureFile(fformats, intSigs);
    }

    @Override
    public FormatEnum[] getDetectedFormats() {
        FFSignatureFile fsigfile = CONF_MAP.get(this.configFile);
        ArrayList<FormatEnum> result = new ArrayList<FormatEnum>();
        for (int i = 0; i < fsigfile.getNumFileFormats(); ++i) {
            FileFormat fformat = fsigfile.getFileFormat(i);
            FormatId fid = this.getFormatEnum(fformat);
            FormatEnum fenum = fid.format;
            if (FormatEnum.UNLISTED.equals(fenum) || FormatEnum.UNKNOWN.equals(fenum)) continue;
            result.add(fenum);
        }
        return result.toArray(new FormatEnum[result.size()]);
    }

    private FormatId getFormatEnum(FileFormat id) {
        FormatEnum fenum = null;
        for (Object key : this.mapping.keySet()) {
            String value = this.mapping.getProperty((String)key);
            if (!value.contains(Integer.toString(id.getID()))) continue;
            String kname = (String)key;
            fenum = FormatEnum.getEnum(this.formatEnumClass, kname);
            break;
        }
        FormatId result = fenum == null ? new FormatId(FormatEnum.UNLISTED, id.getName()) : new FormatId(fenum, id.getVersion());
        return result;
    }

    private XMLReader getXMLReader(SAXModelBuilder mb) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        XMLReader parser = saxParser.getXMLReader();
        mb.setupNamespace(SIGNATURE_FILE_NS, true);
        parser.setContentHandler(mb);
        return parser;
    }

    private FFSignatureFile parseSigFile(URL signatureFileURL) {
        SAXModelBuilder mb = new SAXModelBuilder();
        try {
            XMLReader parser = this.getXMLReader(mb);
            InputStream signatureFileStream = signatureFileURL.openStream();
            parser.parse(new InputSource(signatureFileStream));
            signatureFileStream.close();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error reading configuration file [" + signatureFileURL + "]", e);
        }
        FFSignatureFile fsgf = (FFSignatureFile)mb.getModel();
        fsgf.prepareForUse();
        return fsgf;
    }
}

