/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt.detect.wzf.custom;

import com.gc.iotools.fmt.detect.wzf.custom.FormatException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;

public final class ASN1Reader {
    private static final int CONSTRUCTED = 32;
    private static final int SEQUENCE = 16;
    private static final int TAGGED = 128;
    private boolean eofFound = false;
    private InputStream istream = null;

    protected ASN1Reader(InputStream istream) {
        this.istream = istream;
    }

    protected void check(ASN1ObjectIdentifier expectedObjIdentifier) throws IOException, FormatException {
        try {
            this.readSequence(this.istream);
            this.readTagID(this.istream, expectedObjIdentifier);
        }
        catch (IOException e) {
            throw new FormatException("Error reading pkcs7 or underlying stream", e);
        }
        catch (RuntimeException e) {
            throw new FormatException("Error reading pkcs7", e);
        }
    }

    private int getTagNo(InputStream is, int tag) throws IOException {
        int baseTagNo;
        int tagNo = baseTagNo = tag & 0xFFFFFFDF;
        if ((tag & 0x80) != 0 && (tagNo = tag & 0x1F) == 31) {
            tagNo = 0;
            int b = is.read();
            while (b >= 0 && (b & 0x80) != 0) {
                tagNo |= b & 0x7F;
                tagNo <<= 7;
                b = is.read();
            }
            tagNo |= b & 0x7F;
        }
        return tagNo;
    }

    private int readLength(InputStream stream) throws IOException, FormatException {
        int length = stream.read();
        if (length < 0) {
            throw new FormatException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new FormatException("DER length more than 4 bytes");
            }
            length = 0;
            for (int i = 0; i < size; ++i) {
                int next = stream.read();
                if (next < 0) {
                    throw new FormatException("EOF found reading length");
                }
                length = (length << 8) + next;
            }
            if (length < 0) {
                throw new FormatException("corrupted steam - negative length found");
            }
        }
        return length;
    }

    private void readSequence(InputStream is) throws IOException, FormatException {
        boolean result;
        int tag = this.readTag(is);
        this.readLength(is);
        this.getTagNo(is, tag);
        int baseTagNo = tag & 0xFFFFFFDF;
        boolean bl = result = 16 == baseTagNo;
        if (!result) {
            throw new FormatException("Formato PKCS#7 non riconosciuto. atteso tag SEQUENCE[16] ottenuto [" + baseTagNo + "]");
        }
    }

    private int readTag(InputStream in) throws IOException {
        int tag = in.read();
        if (tag == -1) {
            if (this.eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this.eofFound = true;
            return 0;
        }
        return tag;
    }

    private void readTagID(InputStream is, ASN1ObjectIdentifier expectedIdentifier) throws IOException, FormatException {
        ASN1InputStream asn1Stream = new ASN1InputStream(is);
        ASN1Primitive doi = asn1Stream.readObject();
        asn1Stream.close();
        if (!expectedIdentifier.equals((Object)doi)) {
            throw new FormatException("Expected oid signedData[" + expectedIdentifier + "] got[" + doi + "]");
        }
    }
}

