/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.base;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.base.SimpleElement;
import uk.gov.nationalarchives.droid.signatureFile.FileFormat;

public class FileFormatHit
extends SimpleElement {
    FileFormat myHitFileFormat;
    int myHitType;
    String myHitWarning = "";
    private static final Logger LOG = LoggerFactory.getLogger(FileFormatHit.class);

    public FileFormatHit() {
    }

    public FileFormatHit(FileFormat theFileFormat, int theType, boolean theSpecificity, String theWarning) {
        this.myHitFileFormat = theFileFormat;
        this.myHitType = theType == 15 ? (theSpecificity ? 10 : 11) : theType;
        this.setIdentificationWarning(theWarning);
    }

    public FileFormat getFileFormat() {
        return this.myHitFileFormat;
    }

    public String getFileFormatName() {
        return this.myHitFileFormat.getName();
    }

    public String getFileFormatPUID() {
        return this.myHitFileFormat.getPUID();
    }

    public String getFileFormatVersion() {
        return this.myHitFileFormat.getVersion();
    }

    public int getHitType() {
        return this.myHitType;
    }

    public String getHitTypeVerbose() {
        String theHitType = "";
        if (this.myHitType == 11) {
            theHitType = "Positive (Generic Format)";
        } else if (this.myHitType == 10) {
            theHitType = "Positive (Specific Format)";
        } else if (this.myHitType == 12) {
            theHitType = "Tentative";
        } else if (this.myHitType == 15) {
            theHitType = "Positive";
        }
        return theHitType;
    }

    public String getHitWarning() {
        return this.myHitWarning;
    }

    public String getMimeType() {
        return this.myHitFileFormat.getMimeType();
    }

    public boolean isSpecific() {
        return this.myHitType == 10;
    }

    @Override
    public void setAttributeValue(String theName, String theValue) {
        if (theName.equals("HitStatus")) {
            this.setStatus(theValue);
        } else if (theName.equals("FormatName")) {
            this.setName(theValue);
        } else if (theName.equals("FormatVersion")) {
            this.setVersion(theValue);
        } else if (theName.equals("FormatPUID")) {
            this.setPUID(theValue);
        } else if (theName.equals("HitWarning")) {
            this.setIdentificationWarning(theValue);
        } else {
            String theCMDMessage = "WARNING: Unknown XML attribute " + theName + " found for " + this.getElementName() + " ";
            LOG.warn(theCMDMessage);
        }
    }

    public void setIdentificationWarning(String theWarning) {
        this.myHitWarning = theWarning;
    }

    public void setMimeType(String value) {
        if (this.myHitFileFormat == null) {
            this.myHitFileFormat = new FileFormat();
        }
        this.myHitFileFormat.setAttributeValue("MIMEType", value);
    }

    public void setName(String value) {
        if (this.myHitFileFormat == null) {
            this.myHitFileFormat = new FileFormat();
        }
        this.myHitFileFormat.setAttributeValue("Name", value);
    }

    public void setPUID(String value) {
        if (this.myHitFileFormat == null) {
            this.myHitFileFormat = new FileFormat();
        }
        this.myHitFileFormat.setAttributeValue("PUID", value);
    }

    public void setStatus(String value) {
        if (value.equals("Positive (Generic Format)")) {
            this.myHitType = 11;
        } else if (value.equals("Positive (Specific Format)")) {
            this.myHitType = 10;
        } else if (value.equals("Tentative")) {
            this.myHitType = 12;
        } else if (value.equals("Positive")) {
            this.myHitType = 15;
        } else {
            LOG.warn("Unknown hit status listed: " + value);
        }
    }

    public void setVersion(String value) {
        if (this.myHitFileFormat == null) {
            this.myHitFileFormat = new FileFormat();
        }
        this.myHitFileFormat.setAttributeValue("Version", value);
    }
}

