/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.signatureFile;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.base.SimpleElement;

public class FileFormat
extends SimpleElement {
    private static final Logger LOG = LoggerFactory.getLogger(FileFormat.class);
    private final List<String> extensions = new ArrayList<String>();
    private List<Integer> hasPriorityOver = new ArrayList<Integer>();
    private int identifier;
    private List<Integer> internalSigIDs = new ArrayList<Integer>();
    private String mimeType;
    private String name;
    private String PUID;
    private String version;

    public String getExtension(int theIndex) {
        return this.extensions.get(theIndex);
    }

    protected int getHasPriorityOver(int theIndex) {
        return this.hasPriorityOver.get(theIndex);
    }

    public int getID() {
        return this.identifier;
    }

    public int getInternalSignatureID(int theIndex) {
        return this.internalSigIDs.get(theIndex);
    }

    public String getMimeType() {
        return this.mimeType == null ? "" : this.mimeType;
    }

    public String getName() {
        return this.name;
    }

    public int getNumExtensions() {
        return this.extensions.size();
    }

    public int getNumHasPriorityOver() {
        return this.hasPriorityOver.size();
    }

    public int getNumInternalSignatures() {
        return this.internalSigIDs.size();
    }

    public String getPUID() {
        return this.PUID;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasMatchingExtension(String theExtension) {
        boolean matchingExtension = false;
        for (int iExtension = 0; iExtension < this.getNumExtensions(); ++iExtension) {
            if (!theExtension.equalsIgnoreCase(this.getExtension(iExtension))) continue;
            matchingExtension = true;
        }
        return matchingExtension;
    }

    @Override
    public void setAttributeValue(String theName, String theValue) {
        if (theName.equals("ID")) {
            this.identifier = Integer.parseInt(theValue);
        } else if (theName.equals("Name")) {
            this.name = theValue;
        } else if (theName.equals("Version")) {
            this.version = theValue;
        } else if (theName.equals("PUID")) {
            this.PUID = theValue;
        } else if (theName.equals("MIMEType")) {
            this.mimeType = theValue;
        } else {
            String theCMDMessage = "WARNING: Unknown XML attribute " + this.name + " found for " + this.getElementName() + " ";
            LOG.warn(theCMDMessage);
        }
    }

    public void setExtension(String theExtension) {
        this.extensions.add(theExtension);
    }

    public void setHasPriorityOverFileFormatID(String theID) {
        this.hasPriorityOver.add(Integer.parseInt(theID));
    }

    public void setInternalSignatureID(String theID) {
        this.internalSigIDs.add(Integer.parseInt(theID));
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

