/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDirectoryWalker {
    private final Stack<FileObject> stack = new Stack();
    private final Set<FileFilter> fileFilters = new HashSet<FileFilter>();
    private volatile boolean cancelled = false;
    private volatile Long maxDepth = null;
    private volatile Long minDepth = null;

    private boolean isNoSymLink(File file) throws IOException {
        return file.getCanonicalPath().equals(file.getAbsolutePath());
    }

    private void handle(FileObject file) throws IOException {
        if ((this.minDepth == null || file.depth >= this.minDepth) && this.notFiltered(file.file)) {
            this.handleFileOrDir(file);
        }
        try {
            if (file.file.isDirectory() && (this.maxDepth == null || file.depth < this.maxDepth)) {
                this.handleChilds(file);
            }
        }
        catch (SecurityException e) {
            this.handleRestrictedFile(file.file);
        }
    }

    private void handleChilds(FileObject file) throws IOException, SecurityException {
        Stack<File> stack = new Stack<File>();
        File[] content = file.file.listFiles();
        if (content != null && content.length != 0) {
            for (File f : content) {
                if (!this.isNoSymLink(f)) continue;
                stack.push(f);
            }
            while (!stack.isEmpty()) {
                this.stack.push(new FileObject((File)stack.pop(), file.depth + 1L));
            }
        }
    }

    private void handleFileOrDir(FileObject file) throws IOException {
        if (file.file.isDirectory()) {
            this.handleDir(file.file);
        } else if (file.file.isFile()) {
            this.handleFile(file.file);
        } else {
            this.handleSpecialFile(file.file);
        }
    }

    public synchronized void walk(File ... dirs) throws IOException {
        if (dirs == null || dirs.length == 0) {
            throw new NullPointerException("Directory to walk from must not be null");
        }
        for (File dir : dirs) {
            if (dir == null || !dir.isDirectory()) {
                throw new IOException("No such directory " + dir);
            }
            this.handleStartingDir(dir);
            this.stack.push(new FileObject(dir, 0L));
            while (!this.cancelled && !this.stack.isEmpty()) {
                this.handle(this.stack.pop());
            }
            this.lastAction(this.cancelled);
            this.stack.clear();
        }
    }

    public synchronized void walk(List<File> dirs) throws IOException {
        this.walk(dirs.toArray(new File[dirs.size()]));
    }

    public void stopWalking() {
        this.cancelled = true;
    }

    private boolean notFiltered(File file) {
        if (!this.fileFilters.isEmpty()) {
            for (FileFilter filter : this.fileFilters) {
                if (filter.accept(file)) continue;
                return false;
            }
        }
        return true;
    }

    public AbstractDirectoryWalker setMinDepth(Long min) {
        this.minDepth = min;
        return this;
    }

    public AbstractDirectoryWalker setMaxDepth(Long max) {
        this.maxDepth = max;
        return this;
    }

    public synchronized AbstractDirectoryWalker addFilter(FileFilter filter) {
        this.fileFilters.add(filter);
        return this;
    }

    public void handleSpecialFile(File file) throws IOException {
    }

    protected void handleRestrictedFile(File file) throws IOException {
        throw new IOException("Permission denied for " + file);
    }

    protected void handleStartingDir(File file) throws IOException {
    }

    protected void lastAction(boolean wasCancelled) throws IOException {
    }

    public abstract void handleDir(File var1) throws IOException;

    public abstract void handleFile(File var1) throws IOException;

    private static class FileObject {
        final File file;
        final Long depth;

        FileObject(File file, Long depth) {
            this.file = file;
            this.depth = depth;
        }
    }
}

