/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.kerner.utils.io.FileUtils;
import net.sf.kerner.utils.io.IOUtils;

public class FileCopier {
    private final InputStream inStream;
    private final File outFile;

    public FileCopier(File in, File out) throws IOException {
        if (!FileUtils.fileCheck(in, false)) {
            throw new FileNotFoundException("cannot read " + in);
        }
        this.inStream = IOUtils.getInputStreamFromFile(in);
        this.outFile = out;
    }

    public FileCopier(String inFilePath, String outFilePath) throws IOException {
        File in = new File(inFilePath);
        if (!FileUtils.fileCheck(in, false)) {
            throw new FileNotFoundException("cannot read " + in);
        }
        this.inStream = IOUtils.getInputStreamFromFile(in);
        this.outFile = new File(outFilePath);
    }

    public FileCopier(File inFile, File outDir, String outFileName) throws IOException {
        if (!FileUtils.fileCheck(inFile, false)) {
            throw new FileNotFoundException("cannot read " + inFile);
        }
        this.inStream = IOUtils.getInputStreamFromFile(inFile);
        this.outFile = new File(outDir, outFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copy() throws IOException {
        InputStreamReader reader = new InputStreamReader(this.inStream);
        BufferedReader br = new BufferedReader(reader);
        FileWriter writer = new FileWriter(this.outFile);
        BufferedWriter bw = new BufferedWriter(writer);
        long r = 0L;
        try {
            r = IOUtils.readerToWriter(br, bw);
        }
        finally {
            bw.flush();
            bw.close();
            br.close();
        }
        return r;
    }
}

