/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.kerner.utils.io.AbstractDirectoryWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static boolean delete(File file) throws IOException {
        boolean dirCheck = FileUtils.dirCheck(file, false);
        boolean fileCheck = FileUtils.fileCheck(file, false);
        if (!dirCheck && !fileCheck) {
            throw new IOException("cannot access [" + file + "]");
        }
        if (dirCheck) {
            return FileUtils.deleteDir(file);
        }
        return file.delete();
    }

    public static boolean deleteDir(File dir) throws IOException {
        File[] files;
        boolean dirCheck = FileUtils.dirCheck(dir, false);
        if (!dirCheck) {
            throw new IOException("cannot access [" + dir + "]");
        }
        for (File f : files = dir.listFiles()) {
            if (FileUtils.delete(f)) continue;
            return false;
        }
        return true;
    }

    public static boolean dirCheck(File dir, boolean createIfAbsend) {
        if (createIfAbsend) {
            if (dir.exists()) {
                return dir.canRead() && dir.isDirectory();
            }
            return dir.mkdirs();
        }
        return dir.exists() && dir.canRead() && dir.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileCheck(File file, boolean createIfAbsend) {
        if (createIfAbsend) {
            File file2 = file;
            synchronized (file2) {
                if (file.exists()) {
                    return file.canRead() && file.isFile();
                }
                try {
                    boolean b = file.getParentFile().mkdirs();
                    b = file.createNewFile();
                    return b;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return file.exists() && file.canRead() && file.isFile();
    }

    public static List<File> getAllFilesInDir(File dir, final boolean includeSubDirs) throws IOException {
        final ArrayList<File> result = new ArrayList<File>();
        new AbstractDirectoryWalker(){

            public void handleDir(File dir) throws IOException {
                if (includeSubDirs) {
                    result.addAll(FileUtils.getAllFilesInDir(dir, includeSubDirs));
                }
            }

            public void handleFile(File file) throws IOException {
                result.add(file);
            }
        }.walk(dir);
        Collections.sort(result);
        return result;
    }

    private FileUtils() {
    }
}

