/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import net.sf.kerner.utils.impl.util.UtilString;
import net.sf.kerner.utils.io.buffered.impl.BufferedStringReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    public static final int DEFAULT_BUFFER = 8192;
    public static final char NEW_LINE_CHAR = UtilString.NEW_LINE_STRING.charAt(0);
    public static final String NEW_LINE_STRING = UtilString.NEW_LINE_STRING;
    public static final char NULL_CHAR = '\u0000';

    public static void closeProperly(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <V> V deepCopy(Class<V> c, Serializable s) throws IOException, ClassNotFoundException {
        if (c == null || s == null) {
            throw new NullPointerException();
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        new ObjectOutputStream(bs).writeObject(s);
        ByteArrayInputStream bi = new ByteArrayInputStream(bs.toByteArray());
        V v = c.cast(new ObjectInputStream(bi).readObject());
        bs.close();
        bi.close();
        return v;
    }

    public static BufferedInputStream getBufferedInputStreamFromFile(File file) throws IOException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static BufferedOutputStream getBufferedOutputStreamForFile(File file) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public static InputStream getInputStreamFromFile(File file) throws IOException {
        return new FileInputStream(file);
    }

    public static long getOccource(char c, File file) throws IOException {
        return IOUtils.getOccource(c, new FileInputStream(file));
    }

    public static long getOccource(char c, InputStream stream) throws IOException {
        return IOUtils.getOccource(c, IOUtils.inputStreamToReader(stream));
    }

    public static long getOccource(char c, Reader reader) throws IOException {
        char[] line;
        BufferedStringReader r = new BufferedStringReader(reader);
        long result = 0L;
        while ((line = r.nextChars()) != null) {
            for (char l : line) {
                if (l != c) continue;
                ++result;
            }
        }
        r.close();
        return result;
    }

    public static OutputStream getOutputStreamForFile(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    public static long InputStreamToFile(InputStream stream, File file) throws IOException {
        FileWriter w = new FileWriter(file);
        InputStreamReader r = new InputStreamReader(stream);
        long result = IOUtils.readerToWriter(new InputStreamReader(stream), w);
        IOUtils.closeProperly(w);
        IOUtils.closeProperly(r);
        return result;
    }

    public static long inputStreamToOutputStream(InputStream in, OutputStream out) throws IOException {
        return IOUtils.inputStreamToOutputStream(in, out, 8192);
    }

    public static long inputStreamToOutputStream(InputStream in, OutputStream out, int buffer) throws IOException {
        if (buffer < 1) {
            buffer = 8192;
        }
        byte[] byteBuffer = new byte[buffer];
        long count = 0L;
        int n = 0;
        while ((n = in.read(byteBuffer)) != -1) {
            out.write(byteBuffer, 0, n);
            count += (long)n;
        }
        out.flush();
        return count;
    }

    public static Reader inputStreamToReader(InputStream in) {
        return new InputStreamReader(in);
    }

    public static long inputStreamToWriter(InputStream in, Writer out) throws IOException {
        InputStreamReader inr = new InputStreamReader(in);
        return IOUtils.readerToWriter(inr, out);
    }

    public static long inputStreamToWriter(InputStream in, Writer out, int buffer) throws IOException {
        InputStreamReader inr = new InputStreamReader(in);
        return IOUtils.readerToWriter(inr, out, buffer);
    }

    public static void objectToFile(Serializable s, File file) throws IOException {
        if (s == null || file == null) {
            throw new NullPointerException();
        }
        IOUtils.objectToStream(s, new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void objectToStream(Serializable s, OutputStream stream) throws IOException {
        if (s == null || stream == null) {
            throw new NullPointerException();
        }
        ObjectOutputStream outStream = null;
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(stream);
            outStream = new ObjectOutputStream(bos);
            outStream.writeObject(s);
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    public static long outputStreamToReader(OutputStream out, Reader reader) throws IOException {
        OutputStreamWriter outw = new OutputStreamWriter(out);
        return IOUtils.readerToWriter(reader, outw);
    }

    public static Writer outputStreamToWriter(OutputStream out) {
        return new OutputStreamWriter(out);
    }

    public static long readerToWriter(Reader reader, Writer writer) throws IOException {
        return IOUtils.readerToWriter(reader, writer, 0);
    }

    public static long readerToWriter(Reader reader, Writer writer, int buffer) throws IOException {
        if (buffer < 1) {
            buffer = 8192;
        }
        char[] charBuffer = new char[buffer];
        long count = 0L;
        int n = 0;
        while ((n = reader.read(charBuffer)) != -1) {
            writer.write(charBuffer, 0, n);
            count += (long)n;
        }
        writer.flush();
        return count;
    }

    private IOUtils() {
    }
}

