/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.io.buffered.impl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.sf.kerner.utils.impl.util.UtilArray;
import net.sf.kerner.utils.io.IOUtils;
import net.sf.kerner.utils.io.buffered.CharReader;

public class BufferedStringReader
implements Closeable,
CharReader {
    protected BufferedReader reader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedStringReader(BufferedReader reader) {
        Class<BufferedStringReader> clazz = BufferedStringReader.class;
        synchronized (BufferedStringReader.class) {
            this.reader = reader;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedStringReader(File file) throws IOException {
        Class<BufferedStringReader> clazz = BufferedStringReader.class;
        synchronized (BufferedStringReader.class) {
            this.reader = new BufferedReader(IOUtils.inputStreamToReader(new FileInputStream(file)));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedStringReader(InputStream stream) {
        Class<BufferedStringReader> clazz = BufferedStringReader.class;
        synchronized (BufferedStringReader.class) {
            this.reader = new BufferedReader(IOUtils.inputStreamToReader(stream));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedStringReader(Reader reader) {
        Class<BufferedStringReader> clazz = BufferedStringReader.class;
        synchronized (BufferedStringReader.class) {
            this.reader = new BufferedReader(reader, 8192);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized void close() {
        IOUtils.closeProperly(this.reader);
    }

    public synchronized int nextChar() throws IOException {
        return this.reader.read();
    }

    public synchronized char[] nextChars() throws IOException {
        return this.nextChars(8192);
    }

    public synchronized char[] nextChars(int bufferSize) throws IOException {
        if (bufferSize < 1) {
            throw new IllegalArgumentException();
        }
        char[] buffer = new char[bufferSize];
        int read = this.reader.read(buffer);
        if (read == -1) {
            return null;
        }
        return UtilArray.trim((char[])buffer, (int)read);
    }

    public synchronized String nextLine() throws IOException {
        return this.reader.readLine();
    }

    public synchronized String nextString() throws IOException {
        return this.nextString(8192);
    }

    public synchronized String nextString(int bufferSize) throws IOException {
        char[] result = this.nextChars(bufferSize);
        if (result == null) {
            return null;
        }
        return String.valueOf(result);
    }
}

