/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.io.buffered.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.NoSuchElementException;
import net.sf.kerner.utils.io.IOUtils;
import net.sf.kerner.utils.io.buffered.AbstractBufferedReader;
import net.sf.kerner.utils.io.buffered.GeneralIOIterator;
import net.sf.kerner.utils.math.ArithmeticSavety;

public class CharIterator
extends AbstractBufferedReader
implements GeneralIOIterator {
    private final boolean checkIndexOverflow;
    protected volatile int peek = -1;
    private volatile long currentIndex = 0L;
    private volatile boolean neu = true;

    public CharIterator(BufferedReader reader) throws IOException {
        super(reader);
        this.checkIndexOverflow = false;
    }

    public CharIterator(File file) throws IOException {
        super(file);
        this.checkIndexOverflow = false;
    }

    public CharIterator(InputStream stream) throws IOException {
        super(stream);
        this.checkIndexOverflow = false;
    }

    public CharIterator(Reader reader) throws IOException {
        super(reader);
        this.checkIndexOverflow = false;
    }

    public CharIterator(Reader reader, boolean checkIndexOverflow) throws IOException {
        super(reader);
        this.checkIndexOverflow = checkIndexOverflow;
    }

    public CharIterator(BufferedReader reader, boolean checkIndexOverflow) throws IOException {
        super(reader);
        this.checkIndexOverflow = checkIndexOverflow;
    }

    public CharIterator(File file, boolean checkIndexOverflow) throws IOException {
        super(file);
        this.checkIndexOverflow = checkIndexOverflow;
    }

    public CharIterator(InputStream stream, boolean checkIndexOverflow) throws IOException {
        super(stream);
        this.checkIndexOverflow = checkIndexOverflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized char nextChar() throws IOException {
        if (this.hasNext()) {
            try {
                int result = this.peek;
                this.peek = this.reader.read();
                if (result == -1) {
                    char c = this.nextChar();
                    return c;
                }
                char c = (char)result;
                return c;
            }
            finally {
                this.neu = false;
            }
        }
        throw new NoSuchElementException("no more elements");
    }

    public char[] nextChars() throws IOException {
        return this.nextChars(8192);
    }

    public synchronized char[] nextChars(int buffer) throws IOException {
        int cnt;
        if (buffer < 1) {
            throw new IllegalArgumentException("invalid buffer size");
        }
        StringBuilder result = new StringBuilder();
        for (cnt = 0; this.hasNext() && cnt < buffer; ++cnt) {
            result.append(this.nextChar());
        }
        if (this.checkIndexOverflow) {
            ArithmeticSavety.addLong((long)this.currentIndex, (long)cnt);
        } else {
            this.currentIndex += (long)cnt;
        }
        return result.toString().toCharArray();
    }

    public void close() {
        IOUtils.closeProperly(this.reader);
    }

    public synchronized boolean hasNext() {
        return this.peek != -1 || this.neu;
    }

    public synchronized long nextIndex() {
        if (this.checkIndexOverflow) {
            return ArithmeticSavety.addLong((long)this.currentIndex, (long)1L);
        }
        return this.currentIndex + 1L;
    }
}

