/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.io.lazy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import net.sf.kerner.utils.io.GenericReader;
import net.sf.kerner.utils.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyStringReader
implements GenericReader<String> {
    @Override
    public String read(File file) throws IOException {
        return this.read(IOUtils.getInputStreamFromFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String read(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException();
        }
        StringWriter writer = new StringWriter();
        try {
            IOUtils.readerToWriter(reader, writer);
            String string = writer.toString();
            return string;
        }
        finally {
            IOUtils.closeProperly(reader);
            IOUtils.closeProperly(writer);
        }
    }

    @Override
    public String read(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        return this.read(IOUtils.inputStreamToReader(stream));
    }
}

