/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.io.lazy;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import net.sf.kerner.utils.io.GenericWriter;
import net.sf.kerner.utils.io.IOUtils;

public class LazyStringWriter
implements GenericWriter {
    private final String string;

    public LazyStringWriter(Object toString) {
        if (toString == null) {
            throw new NullPointerException();
        }
        this.string = toString.toString();
    }

    public void write(File file) throws IOException {
        this.write(new FileWriter(file));
    }

    public void write(OutputStream stream) throws IOException {
        this.write(IOUtils.outputStreamToWriter(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer) throws IOException {
        StringReader reader = null;
        try {
            reader = new StringReader(this.string);
            IOUtils.readerToWriter(reader, writer);
        }
        finally {
            IOUtils.closeProperly(writer);
            IOUtils.closeProperly(reader);
        }
    }
}

