/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.kerner.utils.async.BatchListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncBatchMonitor<I, R> {
    private final Map<I, R> identifier2Result = new HashMap<I, R>();
    private final Map<I, Exception> itendifier2Exception = new HashMap<I, Exception>();
    private final Collection<BatchListener<I>> listeners = new ArrayList<BatchListener<I>>();

    public AsyncBatchMonitor(List<? extends I> identifiers) {
        this.init(identifiers);
    }

    private void init(List<? extends I> identifiers) {
        for (I i : identifiers) {
            this.identifier2Result.put(i, null);
            this.itendifier2Exception.put(i, null);
        }
    }

    protected void allDone() {
        boolean error = false;
        for (Exception exception : this.itendifier2Exception.values()) {
            if (exception == null) continue;
            error = true;
            break;
        }
        for (BatchListener batchListener : this.listeners) {
            batchListener.allDone(error);
        }
    }

    protected boolean isDone(I ident) {
        if (this.identifier2Result.get(ident) != null) {
            return true;
        }
        return this.itendifier2Exception.get(ident) != null;
    }

    protected boolean finished() {
        for (I i : this.identifier2Result.keySet()) {
            if (this.isDone(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportResult(I identifier, R result) {
        Map<I, R> map = this.identifier2Result;
        synchronized (map) {
            if (this.identifier2Result.containsKey(identifier)) {
                this.identifier2Result.put(identifier, result);
                if (this.finished()) {
                    this.allDone();
                }
            } else {
                throw new NotRegisteredException("identifier unknown [" + identifier + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportError(I identifier, Exception error) {
        Map<I, Exception> map = this.itendifier2Exception;
        synchronized (map) {
            if (this.itendifier2Exception.containsKey(identifier)) {
                this.itendifier2Exception.put(identifier, error);
                for (BatchListener<I> l : this.listeners) {
                    l.errorOccured(identifier, error);
                }
                if (this.finished()) {
                    this.allDone();
                }
            } else {
                throw new NotRegisteredException("identifier unknown [" + identifier + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(BatchListener<I> l) {
        Collection<BatchListener<I>> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l);
        }
    }

    public List<Exception> getExceptions() {
        return new ArrayList<Exception>(this.itendifier2Exception.values());
    }

    public List<R> getResults() {
        return new ArrayList<R>(this.identifier2Result.values());
    }

    public Set<I> getIdentifiers() {
        return new TreeSet<I>(this.identifier2Result.keySet());
    }

    public static class NotRegisteredException
    extends RuntimeException {
        private static final long serialVersionUID = 9099067750620713811L;

        public NotRegisteredException() {
        }

        public NotRegisteredException(String message, Throwable cause) {
            super(message, cause);
        }

        public NotRegisteredException(String message) {
            super(message);
        }

        public NotRegisteredException(Throwable cause) {
            super(cause);
        }
    }

    public static class AlreadyRegisteredException
    extends RuntimeException {
        private static final long serialVersionUID = -3723305005162834457L;

        public AlreadyRegisteredException() {
        }

        public AlreadyRegisteredException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }

        public AlreadyRegisteredException(String arg0) {
            super(arg0);
        }

        public AlreadyRegisteredException(Throwable arg0) {
            super(arg0);
        }
    }
}

