/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureTaskNotifying<V>
extends FutureTask<V> {
    private final String identifier;
    private final List<ListenerDone> listeners = new ArrayList<ListenerDone>();

    public FutureTaskNotifying(Callable<V> callable) {
        super(callable);
        this.identifier = null;
    }

    public FutureTaskNotifying(Callable<V> callable, String identifier) {
        super(callable);
        this.identifier = identifier;
    }

    public FutureTaskNotifying(Runnable runnable, V result) {
        super(runnable, result);
        this.identifier = null;
    }

    public FutureTaskNotifying(Runnable runnable, V result, String identifier) {
        super(runnable, result);
        this.identifier = identifier;
    }

    public synchronized void addAllListener(List<ListenerDone> listeners) {
        for (ListenerDone l : listeners) {
            this.addListener(l);
        }
    }

    public synchronized void addListener(ListenerDone listener) {
        this.listeners.add(listener);
    }

    @Override
    protected synchronized void done() {
        super.done();
        for (ListenerDone listener : this.listeners) {
            listener.isDone(this);
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ListenerDone {
        public void isDone(FutureTaskNotifying<?> var1);
    }
}

