/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.sf.kerner.utils.concurrent.FutureTaskNotifying;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolExecutorNotifying
extends ThreadPoolExecutor {
    private String identifier;
    private final List<FutureTaskNotifying.ListenerDone> listeners = new ArrayList<FutureTaskNotifying.ListenerDone>();

    public static ThreadPoolExecutorNotifying build(int numCPUs) {
        return new ThreadPoolExecutorNotifying(numCPUs, numCPUs, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public ThreadPoolExecutorNotifying(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public ThreadPoolExecutorNotifying(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public ThreadPoolExecutorNotifying(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public ThreadPoolExecutorNotifying(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public synchronized <T> void addListenerDone(FutureTaskNotifying.ListenerDone listener) {
        this.listeners.add(listener);
    }

    public synchronized String getIdentifier() {
        return this.identifier;
    }

    @Override
    protected synchronized <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        FutureTaskNotifying<T> hannes = new FutureTaskNotifying<T>(callable, this.identifier);
        this.identifier = null;
        hannes.addAllListener(this.listeners);
        return hannes;
    }

    @Override
    protected synchronized <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        FutureTaskNotifying<T> hannes = new FutureTaskNotifying<T>(runnable, value, new String(this.identifier));
        this.identifier = null;
        hannes.addAllListener(this.listeners);
        return hannes;
    }

    public synchronized void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

