/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.counter;

import java.util.ArrayList;
import java.util.List;

public class Counter {
    private final int initCnt;
    private volatile int cnt = 0;
    private volatile int interval = 1;
    private volatile int intervalHelper = 0;
    private volatile boolean performed = false;
    private volatile List<Runnable> runner = new ArrayList<Runnable>();

    public Counter() {
        this.initCnt = 0;
    }

    public Counter(Runnable runner) {
        this.initCnt = 0;
        this.runner.add(runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter(int count) {
        Class<Counter> clazz = Counter.class;
        synchronized (Counter.class) {
            this.cnt = count;
            this.initCnt = count;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter(int count, Runnable runner) {
        Class<Counter> clazz = Counter.class;
        synchronized (Counter.class) {
            this.cnt = count;
            this.initCnt = count;
            this.runner.add(runner);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void checkPerform() {
        if (this.intervalHelper == this.interval) {
            this.perform();
            this.performed = true;
            this.intervalHelper = 0;
        } else {
            this.performed = false;
        }
    }

    public synchronized void count() {
        ++this.cnt;
        ++this.intervalHelper;
        this.checkPerform();
    }

    public synchronized void finish() {
        if (!this.performed) {
            this.perform();
        }
        this.intervalHelper = 0;
        this.cnt = this.initCnt;
        this.interval = 1;
    }

    public synchronized void setInterval(int interval) {
        if (interval < 1) {
            throw new NumberFormatException("interval must be >= 1");
        }
        this.interval = interval;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getCount() {
        return this.cnt;
    }

    public int getInitCount() {
        return this.initCnt;
    }

    public synchronized void setCount(int count) {
        this.cnt = count;
        this.intervalHelper = 0;
    }

    public String toString() {
        return Integer.toString(this.getCount());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cnt;
        result = 31 * result + this.interval;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Counter)) {
            return false;
        }
        Counter other = (Counter)obj;
        if (this.cnt != other.cnt) {
            return false;
        }
        return this.interval == other.interval;
    }

    public synchronized void addRunnable(Runnable runner) {
        this.runner.add(runner);
    }

    public synchronized void clearRunnables() {
        this.runner.clear();
    }

    public synchronized void perform() {
        for (Runnable r : this.runner) {
            r.run();
        }
    }
}

