/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.counter;

import java.util.ArrayList;
import java.util.List;
import net.sf.kerner.utils.counter.Counter;

public class PercentDoneCounter
extends Counter {
    private final List<Listener> listeners = new ArrayList<Listener>();

    public PercentDoneCounter(final int totalElements) {
        this.setInterval(totalElements / 100);
        this.addRunnable(new Runnable(){

            public void run() {
                double percent = (double)PercentDoneCounter.this.getCount() / (double)totalElements * 100.0;
                for (Listener l : PercentDoneCounter.this.listeners) {
                    l.update(percent);
                }
            }
        });
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void clearListners() {
        this.listeners.clear();
    }

    public static interface Listener {
        public void update(double var1);
    }
}

