/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.counter;

import java.util.ArrayList;
import java.util.List;
import net.sf.kerner.utils.counter.PercentDoneCounter;
import net.sf.kerner.utils.time.StopWatch;
import net.sf.kerner.utils.time.TimePeriod;

public class PercentDoneCounterWatch
extends PercentDoneCounter
implements PercentDoneCounter.Listener {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private double percentDone;
    private final StopWatch watch = new StopWatch();

    public PercentDoneCounterWatch(int totalElements) {
        super(totalElements);
        this.addListener(this);
        this.addRunnable(new Runnable(){

            public void run() {
                TimePeriod period = PercentDoneCounterWatch.this.watch.stop();
                for (Listener l : PercentDoneCounterWatch.this.listeners) {
                    l.update(PercentDoneCounterWatch.this.percentDone, period);
                }
                PercentDoneCounterWatch.this.watch.start();
            }
        });
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void clearListners() {
        this.listeners.clear();
    }

    public void start() {
        this.watch.start();
    }

    public TimePeriod stop() {
        return this.watch.stop();
    }

    public void update(double percentDone) {
        this.percentDone = percentDone;
    }

    public static interface Listener {
        public void update(double var1, TimePeriod var3);
    }
}

