/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.impl;

import java.util.Map;
import net.sf.kerner.utils.impl.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValue<K, V>
implements Map.Entry<K, V> {
    private final K key;
    private volatile V value;
    private volatile int hashCache;

    public KeyValue(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        this.key = key;
        this.value = value;
    }

    public KeyValue(K key) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        this.key = key;
        this.value = null;
    }

    public KeyValue(KeyValue<K, V> template) {
        this(template.getKey(), template.getValue());
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    @Override
    public int hashCode() {
        int result = this.hashCache;
        if (result == 0) {
            result = 17;
            int prime = 31;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            this.hashCache = result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return Util.equalsOnHashCode(this, obj);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public synchronized V setValue(V value) {
        V result = this.value;
        this.value = value;
        return result;
    }
}

