/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.impl.util;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import net.sf.kerner.utils.impl.util.UtilArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    public static final int NUM_CPUS = Runtime.getRuntime().availableProcessors();
    public static final Locale USER_LOCALE = new Locale(System.getProperty("user.language"));
    public static final File WORKING_DIR = new File(System.getProperty("user.dir"));

    public static void checkForNull(Object ... objects) throws NullPointerException {
        for (Object o : objects) {
            if (o != null) continue;
            throw new NullPointerException();
        }
    }

    public static int deepHashCode(Collection<?> objects) {
        int result = 0;
        for (Object o : objects) {
            if (o instanceof Collection) {
                result += Util.deepHashCode((Collection)o);
                continue;
            }
            if (UtilArray.isArray(o)) {
                result += Util.deepHashCode(Arrays.asList((Object[])o));
                continue;
            }
            result += o.hashCode();
        }
        return result;
    }

    public static boolean equalsOnHashCode(Object o1, Object obj) {
        if (o1 == null && obj == null) {
            return true;
        }
        if (obj == null || o1 == null) {
            return false;
        }
        return o1.hashCode() == obj.hashCode();
    }

    public static String readVersionFromProperties(Class<?> clazz, String propertiesFile) {
        String result;
        block2: {
            result = "n/a";
            try {
                Properties props = new Properties();
                props.load(clazz.getResourceAsStream(propertiesFile));
                result = props.getProperty("version");
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private Util() {
    }
}

