/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kerner.utils.impl.util;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilArray {
    public static byte[] copy(byte[] array) {
        byte[] result = new byte[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static double[] copy(double[] array) {
        double[] result = new double[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static int[] copy(int[] array) {
        int[] result = new int[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static Object[] copy(Object[] array) {
        Object[] result = new Object[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static boolean emptyArray(double[] arr) {
        if (arr == null) {
            return true;
        }
        return arr.length < 1;
    }

    public static boolean emptyArray(int[] arr) {
        if (arr == null) {
            return true;
        }
        return arr.length < 1;
    }

    public static boolean emptyArray(Object[] arr) {
        if (arr == null) {
            return true;
        }
        return arr.length < 1;
    }

    public static boolean isArray(Object o) {
        return o.getClass().isArray();
    }

    public static boolean nullArray(Object[] arr) {
        if (UtilArray.emptyArray(arr)) {
            return true;
        }
        for (Object o : arr) {
            if (o == null) continue;
            if (UtilArray.isArray(o)) {
                return UtilArray.nullArray((Object[])o);
            }
            return false;
        }
        return true;
    }

    public static Double[] toDouble(Collection<? extends Number> numbers) {
        return UtilArray.toDouble(numbers.toArray(new Number[numbers.size()]));
    }

    public static Double[] toDouble(Number ... numbers) {
        Double[] result = new Double[numbers.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Double(numbers[i].doubleValue());
        }
        return result;
    }

    public static Byte toObject(byte i) {
        return i;
    }

    public static Byte[] toObject(byte[] arr) {
        Byte[] result = new Byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = arr[i];
        }
        return result;
    }

    public static Double toObject(double d) {
        return d;
    }

    public static Double[] toObject(double[] arr) {
        Double[] result = new Double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = arr[i];
        }
        return result;
    }

    public static Integer toObject(int i) {
        return i;
    }

    public static Integer[] toObject(int[] arr) {
        Integer[] result = new Integer[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = arr[i];
        }
        return result;
    }

    public static double[] toPrimitive(Double[] arr) {
        double[] result = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = arr[i];
        }
        return result;
    }

    public static int[] toPrimitive(Integer[] arr) {
        int[] result = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = arr[i];
        }
        return result;
    }

    public static double[] toPrimitive(Number[] arr) {
        double[] result = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            result[i] = arr[i].doubleValue();
        }
        return result;
    }

    public static byte[] trim(byte[] array, int size) {
        if (size < 0) {
            return new byte[0];
        }
        if (array.length <= size) {
            return array;
        }
        byte[] result = new byte[size];
        System.arraycopy(array, 0, result, 0, size);
        return result;
    }

    public static char[] trim(char[] array, int size) {
        if (size < 0) {
            return new char[0];
        }
        if (array.length <= size) {
            return array;
        }
        char[] result = new char[size];
        System.arraycopy(array, 0, result, 0, size);
        return result;
    }

    public static int[] trim(int[] array, int size) {
        if (size < 0) {
            return new int[0];
        }
        if (array.length <= size) {
            return array;
        }
        int[] result = new int[size];
        System.arraycopy(array, 0, result, 0, size);
        return result;
    }

    private UtilArray() {
    }
}

